set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0401',
      '33234223',
      34,
      4.567683,
      '3000231',
      120,
      3,
      0.296927,
      1,
      '404433',
      5.523591,
      NULL,
      49,
      35,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1.015200,
      1,
      2.564326,
      2,
      0,
      0,
      0,
      1.750872,
      1,
      0,
      1,
      0,
      NULL,
      0.288193,
      1.205715,
      NULL,
      1.847769,
      1,
      7.538034,
      1,
      2.506745,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.560095,
      NULL,
      NULL,
      1,
      0.010180,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000612,
      NULL,
      1.954732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.116800,
      0,
      5,
      2,
      0.094841,
      1,
      2.607444,
      1,
      1.056487,
      1,
      1,
      NULL,
      1.930351,
      1,
      1.751430,
      NULL,
      NULL,
      0,
      6.498789,
      4,
      2,
      4.324776,
      0,
      0.806680,
      NULL,
      4,
      1.818497,
      3.924587,
      5.808379,
      1.694411,
      1.340301,
      0,
      0.917370,
      0.253928,
      5,
      5.534562,
      0,
      5.903093,
      1.284890,
      NULL,
      5.050762,
      NULL,
      0.052737,
      1.627794,
      2.408240,
      2,
      1.868765,
      0.988053,
      1,
      0.240921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.081590,
      1.391335,
      2,
      0,
      0,
      0.583953,
      0,
      0.959934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.175303,
      3.184559,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.666925,
      0,
      3.585556,
      0.948914,
      1.428654,
      0,
      1.627812,
      2,
      3.378636,
      0,
      1.863136,
      0,
      1,
      1,
      NULL,
      0.265350,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.593701,
      '10123',
      '',
      '',
      1.113437,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.434647,
      1.043031,
      0.353187,
      1.858153,
      2.603300,
      3,
      NULL,
      2,
      0);
commit;
end;
/


