set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4341',
      '43323302',
      NULL,
      66,
      '2443414',
      NULL,
      0,
      NULL,
      3,
      '321400',
      0.537498,
      ' 3- 1-1989',
      35,
      25,
      1.696243,
      NULL,
      1,
      2.424288,
      0.573207,
      NULL,
      1.200602,
      0,
      1.449062,
      NULL,
      1,
      1,
      0,
      NULL,
      0.140676,
      1,
      1,
      0,
      2,
      1.705513,
      1.114648,
      0,
      1,
      0.934466,
      NULL,
      NULL,
      3,
      0,
      0,
      1.914022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.016199,
      0,
      0.497842,
      1.174997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.251582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830709,
      1.458036,
      1,
      NULL,
      0.522829,
      NULL,
      1,
      1.020778,
      1.189936,
      NULL,
      2,
      0,
      1.643246,
      3,
      0.455650,
      1.706239,
      1.477900,
      0.954543,
      1.061086,
      NULL,
      NULL,
      5,
      3.504203,
      NULL,
      NULL,
      1.431395,
      NULL,
      1,
      4,
      1.730295,
      5.048860,
      6.726148,
      0.297233,
      1.581182,
      5,
      1.177053,
      1.090377,
      1.596718,
      6,
      5,
      3.438358,
      4,
      6.925473,
      NULL,
      NULL,
      2.873054,
      0.018906,
      3,
      1,
      1.379081,
      1,
      0.761477,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.091801,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.563949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.988597,
      NULL,
      0.490576,
      NULL,
      NULL,
      NULL,
      4.281193,
      NULL,
      2.134247,
      5.456807,
      0.698688,
      2,
      1.102092,
      NULL,
      NULL,
      NULL,
      1.357023,
      0,
      1.051447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.412827,
      1,
      3.093065,
      0.430099,
      NULL,
      2.256482,
      0,
      3.183341,
      2,
      1.389850,
      0,
      NULL,
      0.449824,
      1,
      0.216492,
      1,
      1,
      1.683462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '30000',
      '',
      NULL,
      0.167852,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.927841,
      0.942031,
      3,
      3.141094,
      0.593724,
      1.490884,
      NULL,
      1.487332,
      NULL);
commit;
end;
/


