set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0431',
      '13441343',
      32,
      NULL,
      NULL,
      176,
      4,
      2,
      1,
      NULL,
      NULL,
      ' 4- 4-1979',
      10,
      49,
      0,
      NULL,
      NULL,
      NULL,
      0.004086,
      1,
      0,
      1,
      NULL,
      3.619723,
      0.215094,
      NULL,
      3.224981,
      0,
      3,
      NULL,
      0.828943,
      3,
      0.184538,
      1.390396,
      0,
      0,
      0.835850,
      1.659065,
      6.611809,
      NULL,
      0.075553,
      3.707002,
      3,
      1.482841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.683435,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760041,
      0.196387,
      0.065013,
      0.516342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.015887,
      1,
      0,
      1,
      4,
      1,
      0,
      1,
      NULL,
      4.288213,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1.981753,
      NULL,
      0,
      1.953845,
      4.125243,
      1,
      1,
      0,
      5.920982,
      0,
      3.058652,
      NULL,
      0.311417,
      8,
      0.775027,
      0,
      0,
      5.049110,
      NULL,
      1,
      8.605898,
      7.552790,
      7,
      5,
      1.827318,
      6.413480,
      0,
      1,
      0,
      2.140943,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.557014,
      1.009601,
      NULL,
      1,
      0,
      0,
      0.134552,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513339,
      1,
      0,
      0,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4.515234,
      NULL,
      7,
      1.265986,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.434061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.076925,
      1.243944,
      0.028917,
      0.326267,
      NULL,
      0,
      1.211436,
      3.368658,
      2.816711,
      1,
      NULL,
      0,
      0.563321,
      NULL,
      1.358787,
      NULL,
      1.462738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '41022',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0.895954,
      '',
      '',
      NULL,
      2,
      3.443860,
      1.571754,
      2,
      NULL,
      0,
      1,
      0,
      3);
commit;
end;
/


