set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8012438';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4203',
      '20130212',
      NULL,
      69.767076,
      '2414243',
      64,
      3,
      1,
      3,
      '442130',
      4,
      ' 4- 3-1978',
      30,
      39.077115,
      0.430456,
      NULL,
      1.371619,
      NULL,
      1.990772,
      1.154443,
      NULL,
      NULL,
      1.089754,
      1.648409,
      1,
      0,
      1,
      1.188096,
      0.381349,
      0,
      0,
      0.025521,
      5,
      NULL,
      2.031498,
      NULL,
      1,
      0.165625,
      3.896926,
      NULL,
      5,
      2.356209,
      NULL,
      1.743243,
      NULL,
      NULL,
      0.516355,
      NULL,
      NULL,
      1,
      0.039242,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536323,
      1.899207,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.316101,
      2,
      2.281138,
      0,
      1.972408,
      0,
      1.842302,
      0.475858,
      0.785001,
      0.607742,
      1,
      0.030846,
      0,
      0,
      0.559400,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      7.432008,
      0.509871,
      6.992211,
      1,
      1.616784,
      8.419797,
      0.845074,
      1,
      NULL,
      5,
      3.555542,
      1,
      6.273239,
      4,
      NULL,
      9,
      0,
      9.028656,
      NULL,
      4.308102,
      0.140538,
      4,
      2,
      NULL,
      0.690273,
      1.141222,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1.605761,
      1.048033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.944959,
      1,
      1.617726,
      3.179767,
      2,
      3.771140,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.386703,
      0,
      2.995906,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440891,
      NULL,
      0.047596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752064,
      NULL,
      1,
      0.399435,
      3,
      1.950427,
      NULL,
      1.992804,
      0,
      NULL,
      2,
      0.435612,
      1.656292,
      1.979388,
      NULL,
      0.872051,
      1,
      1.664951,
      1.912556,
      1.158555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '00111',
      '',
      '',
      1.700420,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      1.384823,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3.469516,
      0.570112);
commit;
end;
/


