set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24',
      25,
      10,
      NULL,
      10.442892,
      2,
      3,
      0,
      '413122',
      5.390039,
      '10- 2-1985',
      44.946511,
      56.864818,
      1,
      NULL,
      0.134031,
      NULL,
      0,
      1.892763,
      2.643996,
      0.765699,
      0.787213,
      0,
      0,
      0.916896,
      6.803280,
      1.806303,
      0.756347,
      0.175481,
      0.985568,
      NULL,
      6,
      NULL,
      6.893387,
      3.485502,
      NULL,
      3.900645,
      2,
      1,
      NULL,
      1.053822,
      1.780051,
      1.679256,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.784536,
      2.106973,
      1.056530,
      0.537180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.283209,
      NULL,
      0,
      5,
      0,
      0,
      1.305593,
      0,
      NULL,
      NULL,
      1.651981,
      NULL,
      NULL,
      1,
      6.988726,
      NULL,
      0.850225,
      5,
      7.609090,
      4,
      0.120728,
      NULL,
      1,
      0.597630,
      1.822189,
      1.297453,
      0,
      1.428084,
      1.808396,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.005168,
      1,
      NULL,
      1,
      0.192391,
      0.675790,
      NULL,
      NULL,
      0.934260,
      0,
      1,
      5.340793,
      3.439622,
      3,
      0,
      1,
      NULL,
      6,
      4,
      3,
      0,
      6.679801,
      0.994829,
      4.197879,
      0,
      1,
      1,
      NULL,
      1.121201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      3,
      6.428051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265408,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143534,
      0,
      5.538261,
      1,
      1.459730,
      1,
      5,
      0,
      0.926193,
      0,
      NULL,
      2.786476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.978018,
      2.811940,
      2.650027,
      1,
      1.089813,
      0,
      NULL,
      1.097967,
      2,
      1,
      0.298317,
      3.831856,
      0,
      2,
      NULL,
      1.802072,
      0,
      NULL,
      NULL,
      1.125967,
      NULL,
      1.729019,
      1,
      1.018276,
      2,
      NULL,
      0,
      0,
      0.927647,
      1,
      0.187599,
      0.857596,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.472548,
      0.938947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991400,
      1,
      NULL,
      0,
      NULL,
      0.033119,
      2,
      6.473901,
      '21030',
      '40411',
      '41430',
      0,
      '',
      '',
      '',
      3.200877,
      NULL,
      '',
      '',
      1.469257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


