set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      '00413203',
      NULL,
      14,
      '3220131',
      10.255927,
      3,
      0.200315,
      1,
      '332421',
      4.424959,
      '11-29-1984',
      33.516055,
      13,
      0.375396,
      NULL,
      3.404041,
      1,
      NULL,
      0,
      0.662440,
      3.544444,
      NULL,
      1.831455,
      0.155405,
      0.458313,
      NULL,
      0,
      NULL,
      4.063534,
      0.880946,
      1,
      1.390058,
      0.865585,
      0.200290,
      0.784926,
      3,
      0,
      NULL,
      NULL,
      5.671753,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.097075,
      NULL,
      NULL,
      NULL,
      1,
      1.064420,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.000643,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      1.873787,
      NULL,
      NULL,
      1,
      2.050802,
      0,
      1.680417,
      1.932490,
      2,
      NULL,
      0.225627,
      NULL,
      0,
      1.911837,
      1,
      1,
      NULL,
      NULL,
      0.107160,
      0,
      0,
      0.657349,
      NULL,
      0.780583,
      3,
      1.680593,
      1,
      3.518529,
      NULL,
      2,
      0,
      0.397390,
      0,
      0,
      0.112779,
      1,
      0.794464,
      0.593293,
      5,
      7,
      NULL,
      1.832037,
      4.493636,
      6.168890,
      NULL,
      5.545770,
      2,
      6.965592,
      0,
      NULL,
      2.721271,
      2,
      0,
      1.988901,
      4,
      1.674105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.623779,
      0,
      0,
      1.169408,
      0,
      1.669467,
      1.655569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700371,
      NULL,
      NULL,
      NULL,
      NULL,
      1.912683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.051777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.673898,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.068703,
      0.052280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      2,
      2,
      1,
      2,
      NULL,
      1.922532,
      0.459201,
      0.211268,
      0,
      1,
      NULL,
      NULL,
      0.219811,
      1,
      0,
      0,
      1.239349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.577520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377867,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941579,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.536485,
      0.157163,
      0.689864,
      NULL,
      2.890236,
      '40013',
      '04322',
      '44404',
      0.402100,
      '',
      '',
      '',
      1,
      '1013',
      '',
      '',
      4.476918,
      2,
      0.082069,
      0.061497,
      NULL,
      4.921470,
      0,
      1.778458,
      3);
commit;
end;
/


