set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '14334423',
      17.480274,
      4,
      NULL,
      58,
      NULL,
      1.366695,
      2,
      '043442',
      2.028642,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649489,
      1,
      1,
      0,
      1,
      3,
      0.902102,
      3,
      0.506254,
      0,
      6,
      0,
      1.589178,
      10.707259,
      8.175274,
      NULL,
      1,
      1,
      NULL,
      1,
      1.876338,
      0,
      0.131773,
      0,
      1.574707,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.952821,
      0.740466,
      1,
      1.596891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470035,
      1.065000,
      NULL,
      5,
      0,
      1,
      3,
      1.817791,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      1,
      0,
      5,
      2.633445,
      NULL,
      0.531387,
      1.678135,
      5.304381,
      NULL,
      1,
      1.180133,
      4.286116,
      NULL,
      0.905935,
      1.582434,
      1.305184,
      1,
      NULL,
      NULL,
      4,
      1,
      2.383472,
      5.243860,
      4.747703,
      4.377647,
      0,
      0,
      1,
      1.667691,
      0,
      1,
      1.489333,
      0,
      1,
      NULL,
      1.812070,
      8.886339,
      9,
      NULL,
      8,
      4.563178,
      9.928828,
      9,
      1,
      NULL,
      2,
      2.620971,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.075272,
      NULL,
      2,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192834,
      0,
      6.143583,
      NULL,
      0,
      1,
      0.856574,
      NULL,
      NULL,
      NULL,
      NULL,
      3.954876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.965936,
      3,
      3.088411,
      1,
      2.017138,
      1,
      3.742512,
      3,
      1,
      0,
      0,
      0,
      1.276736,
      NULL,
      NULL,
      NULL,
      1.022802,
      NULL,
      1.678659,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      '01332',
      '33303',
      0,
      '',
      NULL,
      '',
      1,
      '3401',
      '',
      '',
      3,
      4,
      1.855954,
      3,
      5,
      0.350712,
      1,
      NULL,
      0.697309);
commit;
end;
/


