set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '21130443',
      66,
      38,
      NULL,
      NULL,
      5,
      1,
      3,
      '001201',
      3.402152,
      ' 9- 2-1990',
      NULL,
      41.154906,
      NULL,
      NULL,
      1,
      2,
      1.570600,
      1.804778,
      2,
      NULL,
      0,
      2,
      0,
      0.783854,
      4,
      0.660898,
      1.643534,
      2.496330,
      6,
      NULL,
      NULL,
      NULL,
      0.858562,
      0.237858,
      2.067579,
      1.642938,
      5,
      1,
      1,
      4.876980,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.885488,
      NULL,
      0,
      0.845521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.296378,
      3,
      NULL,
      3,
      1,
      0.606544,
      0,
      1.045825,
      0,
      NULL,
      NULL,
      1.459136,
      3,
      0,
      0.335175,
      0.826862,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.247307,
      0.903645,
      NULL,
      0,
      0.744001,
      1.681145,
      7,
      6,
      5,
      11.992868,
      6.672693,
      10.144219,
      8.754034,
      0.871780,
      0.178617,
      0.530562,
      NULL,
      NULL,
      4,
      1,
      0.679779,
      1.609188,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193861,
      1,
      0,
      0,
      NULL,
      1.057050,
      0,
      0.431166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.886551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193749,
      NULL,
      NULL,
      3.344728,
      0.725027,
      0,
      0.861643,
      0,
      9,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.360761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.729595,
      NULL,
      3,
      1.674903,
      0.483219,
      3.153978,
      1.111539,
      2.198921,
      0.982632,
      3.485819,
      1,
      0,
      NULL,
      1,
      1,
      0,
      1.160592,
      0,
      NULL,
      0.403802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025815,
      0,
      1.893216,
      NULL,
      0.647607,
      NULL,
      1.474299,
      1,
      5.093865,
      NULL,
      '01231',
      '22310',
      1,
      '',
      '',
      NULL,
      3,
      '1301',
      '',
      '',
      2,
      2,
      NULL,
      2.695871,
      4.619431,
      1,
      NULL,
      2,
      NULL);
commit;
end;
/


