set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-12-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '31403103',
      61.757573,
      35.886457,
      '0300010',
      102,
      4,
      3.892573,
      1,
      '120111',
      5,
      '10- 5-1999',
      20,
      23,
      1,
      NULL,
      2.683718,
      NULL,
      NULL,
      1,
      0.075687,
      0.354599,
      1.857030,
      3.982186,
      1,
      0.300948,
      NULL,
      NULL,
      NULL,
      8.550051,
      9.033053,
      5.151969,
      0.749677,
      0,
      1,
      0,
      2,
      1,
      5,
      1,
      NULL,
      NULL,
      0,
      1.821229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.069826,
      0.751227,
      0.397937,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733977,
      2.645708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.094306,
      1.519940,
      0.417732,
      4,
      0.030942,
      0.377049,
      1.707883,
      2,
      1,
      0.080685,
      0.889889,
      0.515741,
      0,
      1.181150,
      NULL,
      0.052443,
      0.906666,
      0.936986,
      NULL,
      1,
      1.444436,
      0,
      2.227113,
      0,
      0,
      2.086891,
      1,
      0.247272,
      0.248043,
      1,
      0.301840,
      NULL,
      0.403288,
      0.832141,
      NULL,
      5,
      4.956645,
      6.729892,
      0.995280,
      4,
      3,
      9,
      5,
      NULL,
      1,
      NULL,
      3.473670,
      NULL,
      0.267512,
      1.835450,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262169,
      0,
      0,
      0,
      1.175160,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395686,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.708517,
      1,
      3.684501,
      1,
      1.122936,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.422941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.485055,
      0,
      0,
      1.777551,
      NULL,
      2,
      NULL,
      3.741688,
      0,
      0,
      1.299973,
      NULL,
      1.827396,
      1,
      0,
      1,
      1,
      1.177123,
      0,
      1.775241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '13124',
      '11212',
      '40001',
      1,
      NULL,
      '',
      '',
      0,
      '4403',
      '',
      NULL,
      5,
      5.772598,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      0.807136);
commit;
end;
/


