set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1233',
      '11213403',
      62,
      NULL,
      NULL,
      192,
      1,
      NULL,
      2,
      '001220',
      2,
      ' 7- 4-1980',
      NULL,
      22,
      0,
      NULL,
      3.431189,
      NULL,
      2.128068,
      NULL,
      NULL,
      3,
      NULL,
      3,
      1.050187,
      NULL,
      2.912676,
      1.518891,
      0,
      7.078729,
      6.495203,
      1.279952,
      0.105767,
      NULL,
      7.414786,
      0.433059,
      1.315762,
      NULL,
      8.131304,
      NULL,
      4.241574,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596399,
      NULL,
      NULL,
      1.913035,
      1.949181,
      0.919712,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.771324,
      0.871278,
      0.637274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.566778,
      3.813222,
      NULL,
      5,
      6,
      1,
      0,
      1.051693,
      3,
      1,
      NULL,
      1,
      7.278198,
      NULL,
      1.713822,
      0.475490,
      NULL,
      1.409459,
      NULL,
      0.852805,
      1.470283,
      3,
      3.903161,
      3.380718,
      1,
      1.070538,
      NULL,
      0,
      1,
      NULL,
      1.713600,
      3.485703,
      0.946066,
      5,
      0,
      NULL,
      NULL,
      NULL,
      0.172756,
      8.840482,
      7,
      3.355129,
      1,
      5.846747,
      4,
      1.005558,
      1.483525,
      NULL,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457671,
      0,
      1,
      NULL,
      1.517228,
      0,
      NULL,
      0.442302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.252461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484489,
      NULL,
      3.979462,
      3,
      0,
      2,
      1.703425,
      1.066137,
      2.764866,
      1.422918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703715,
      0.006827,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528652,
      2.073298,
      3.867026,
      1,
      0.412815,
      3,
      3,
      0.396446,
      NULL,
      0.642963,
      2,
      1,
      1,
      0.637021,
      NULL,
      NULL,
      1.637074,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.142143,
      '41311',
      '12400',
      '34222',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '2112',
      NULL,
      '',
      2,
      1,
      1.931585,
      NULL,
      0,
      3.858164,
      0.727039,
      3.363541,
      1.973376);
commit;
end;
/


