set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9614652';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1041',
      '11341134',
      56,
      14.192122,
      '3342330',
      72.714961,
      4,
      2,
      2,
      '324330',
      0.643218,
      ' 9-17-1995',
      21,
      15.978301,
      0.432664,
      NULL,
      1,
      1.236150,
      NULL,
      1.752490,
      0,
      0,
      1,
      0.268536,
      0,
      0,
      5,
      0.790101,
      1.334682,
      3.056320,
      6,
      0.928973,
      2.613705,
      1,
      5,
      1,
      1.055864,
      NULL,
      5.800641,
      1,
      NULL,
      0,
      4.948897,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.829781,
      1.354999,
      1,
      1.952807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660086,
      0,
      1,
      0.656333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0.108608,
      2,
      2.621931,
      5,
      0,
      NULL,
      2,
      0,
      1.169318,
      NULL,
      3,
      1.090595,
      1.581477,
      0,
      0,
      0.898567,
      NULL,
      NULL,
      0.818441,
      1.265966,
      NULL,
      NULL,
      4.600319,
      NULL,
      0.703522,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.059443,
      3.634106,
      5,
      9.729441,
      7,
      8.849130,
      8.740525,
      5.603115,
      0,
      1,
      NULL,
      1,
      0,
      2,
      0.589664,
      0.644830,
      0.148974,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.538055,
      NULL,
      0,
      0.163001,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.983557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944907,
      1,
      2.010276,
      0,
      0.763225,
      0,
      NULL,
      0.803532,
      NULL,
      0.920225,
      NULL,
      NULL,
      1.891233,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.696112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.252807,
      1,
      0.777318,
      NULL,
      2.975053,
      NULL,
      1,
      0,
      2,
      2,
      1.969660,
      1.760919,
      1,
      1.258900,
      0.539346,
      0.424070,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.852891,
      NULL,
      '40033',
      '10402',
      1,
      '',
      '',
      '',
      0,
      '3433',
      '',
      '',
      NULL,
      7,
      NULL,
      0,
      1,
      3,
      1.258533,
      0,
      0);
commit;
end;
/


