set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8830571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20',
      27.654481,
      5.533905,
      '1110211',
      NULL,
      0,
      3,
      1,
      '333343',
      3,
      ' 5- 9-1999',
      35,
      21,
      0.539719,
      NULL,
      2.299384,
      3,
      0.143067,
      1,
      2.730986,
      0.641880,
      0,
      1.652111,
      0,
      0,
      2,
      0.521667,
      0,
      3,
      NULL,
      1.921436,
      NULL,
      1,
      NULL,
      1.940906,
      0.577432,
      0,
      NULL,
      1,
      1,
      2,
      1.958678,
      1.412910,
      NULL,
      NULL,
      0.818233,
      NULL,
      NULL,
      3,
      1.336181,
      1.567854,
      1.378892,
      0,
      1.252698,
      0.709779,
      NULL,
      1,
      3.546791,
      2.765396,
      1,
      1.057510,
      2,
      0,
      NULL,
      0,
      0.604926,
      0,
      1,
      0.420114,
      0,
      1,
      1,
      1,
      3,
      1.050168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.454141,
      1,
      2,
      0.569461,
      0.914353,
      4.337547,
      3.069720,
      0,
      0,
      3.904149,
      0,
      0.951722,
      1.483453,
      3,
      NULL,
      0,
      0.405994,
      NULL,
      1.535435,
      NULL,
      NULL,
      0.800194,
      0.356009,
      0,
      0.695015,
      1.722162,
      2.799677,
      0.429039,
      1,
      NULL,
      0,
      2,
      NULL,
      1.829730,
      0.539330,
      2,
      4,
      0,
      0,
      5.806406,
      NULL,
      9,
      2.962986,
      8,
      4.337648,
      1,
      1,
      2.759593,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0.758168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569332,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.366253,
      1.719045,
      2,
      NULL,
      0,
      0.065931,
      NULL,
      0,
      2.556547,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.538689,
      0.337130,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.205328,
      1.420258,
      NULL,
      1.580672,
      NULL,
      2.610662,
      2.873405,
      0.758430,
      2,
      3,
      1,
      1,
      0,
      1.300089,
      NULL,
      1.313743,
      NULL,
      1.202964,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '31132',
      '',
      '',
      1.803903,
      NULL,
      '',
      '',
      1.013298,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


