set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8830571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '200',
      '30240240',
      2.361119,
      4,
      '2223011',
      20,
      4,
      2.286552,
      0,
      NULL,
      2,
      '10-15-1994',
      NULL,
      8,
      1,
      NULL,
      1,
      2,
      1.067211,
      0,
      0,
      NULL,
      2,
      0.908406,
      0,
      1,
      1.365826,
      0.581534,
      1.649692,
      1.854795,
      1.493465,
      1,
      0,
      0.425156,
      1,
      1.003451,
      0.594140,
      0,
      0.257342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935868,
      1.331741,
      1,
      1.698296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.417171,
      1,
      NULL,
      0.356929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.520066,
      4.021294,
      0,
      2.600467,
      0,
      1.892626,
      4.696205,
      1.106074,
      0.505402,
      3.384768,
      1,
      1,
      1.896878,
      3,
      0,
      0,
      NULL,
      0,
      1.013604,
      NULL,
      1.686727,
      1,
      2,
      0.001686,
      0,
      1,
      2,
      0,
      3.124142,
      NULL,
      1.094140,
      0.716003,
      0,
      NULL,
      1.600522,
      5.600921,
      NULL,
      3,
      0,
      3.426662,
      1.866881,
      0.398353,
      NULL,
      3.520711,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.385610,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.853546,
      1.634442,
      0,
      0,
      NULL,
      1,
      1.038361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.056092,
      NULL,
      0.090739,
      NULL,
      2.107984,
      NULL,
      0.216783,
      0.545781,
      1,
      1.043631,
      0.574299,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.916921,
      NULL,
      6,
      2,
      5,
      0.547726,
      NULL,
      NULL,
      NULL,
      6,
      0.266254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593282,
      1.674730,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      1.569255,
      2.971069,
      3,
      0,
      NULL,
      0.332110,
      0.303986,
      NULL,
      0.443275,
      0.851717,
      0.747495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '14203',
      '',
      '',
      1.947322,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      0.121923,
      2.735393,
      NULL,
      3,
      5.843174,
      2.766574,
      0.087981,
      NULL);
commit;
end;
/


