set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8830571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1444',
      '41311023',
      18,
      26,
      '3211142',
      48.436908,
      0,
      NULL,
      3,
      '432312',
      2.789112,
      ' 0-28-1974',
      63.646995,
      20.355604,
      NULL,
      NULL,
      1.069512,
      0.806870,
      0.592368,
      NULL,
      0,
      0.294744,
      2,
      0.564618,
      0.280016,
      1.638166,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.566039,
      0.214483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166081,
      1.861587,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455884,
      1.603994,
      1.102244,
      1.909638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.010677,
      1,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1.610281,
      NULL,
      0.247273,
      0,
      0,
      NULL,
      0.539449,
      0.088350,
      NULL,
      1.348554,
      0,
      1,
      1,
      NULL,
      1.853608,
      1.885974,
      0.307897,
      NULL,
      NULL,
      NULL,
      NULL,
      1.037745,
      1.777197,
      1,
      1.886365,
      NULL,
      NULL,
      0.856646,
      1.833098,
      3.803057,
      0,
      2,
      1,
      1,
      1,
      0,
      1,
      0.927862,
      NULL,
      NULL,
      5.697190,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445656,
      0,
      NULL,
      0,
      1.655842,
      NULL,
      1.774694,
      1.690384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.582420,
      2.639496,
      1,
      NULL,
      NULL,
      NULL,
      1.510189,
      0,
      0,
      4.072866,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.930523,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.353021,
      NULL,
      0,
      1,
      1.984345,
      NULL,
      0.777695,
      NULL,
      0.737638,
      0.134480,
      1,
      NULL,
      NULL,
      0,
      1.309196,
      NULL,
      0,
      1.651141,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.509048,
      '40201',
      NULL,
      '',
      1.685643,
      '',
      '',
      NULL,
      1.363881,
      '',
      '',
      '',
      1,
      2.656317,
      1,
      1.120932,
      3,
      3,
      3.774892,
      NULL,
      NULL);
commit;
end;
/


