set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8830571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1110',
      NULL,
      5,
      NULL,
      '1330313',
      NULL,
      3,
      NULL,
      2,
      NULL,
      5,
      ' 4-19-1982',
      40,
      33,
      0.438749,
      NULL,
      1.949782,
      1.347241,
      3.360789,
      0,
      1.375785,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      4.681838,
      1.991288,
      1.557615,
      3,
      1,
      1.637058,
      0.317368,
      NULL,
      1.360372,
      1,
      1,
      0,
      1.431033,
      0.872235,
      0.887925,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.404157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915161,
      1.700566,
      1.286831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.636288,
      0.832797,
      2,
      0,
      4.187850,
      0,
      NULL,
      0.487388,
      1.432280,
      4.058888,
      NULL,
      5.651527,
      1.512270,
      NULL,
      1.395932,
      1,
      1.281508,
      NULL,
      1,
      1.797947,
      4.288816,
      2.908214,
      1,
      NULL,
      1.925266,
      2.679005,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.101263,
      0.628761,
      NULL,
      1.488041,
      1,
      2.508233,
      3.910469,
      7,
      4,
      6.946597,
      7,
      0.802191,
      1,
      5,
      3,
      0.850859,
      NULL,
      NULL,
      7.272364,
      1.670188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.597180,
      0.397329,
      2,
      0,
      0.029984,
      0.026754,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.816417,
      NULL,
      NULL,
      3.596662,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.226282,
      NULL,
      NULL,
      NULL,
      1.610168,
      NULL,
      3,
      0.351692,
      NULL,
      2,
      1.910824,
      NULL,
      NULL,
      NULL,
      NULL,
      2.915086,
      1.606965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1.122879,
      1,
      1.197017,
      NULL,
      0.263609,
      1,
      NULL,
      1,
      0.015472,
      NULL,
      1,
      0,
      0.974474,
      0,
      NULL,
      1.840154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.098523,
      NULL,
      '',
      NULL,
      0.393434,
      '',
      '',
      '',
      1.674766,
      '',
      '',
      '',
      2.247051,
      NULL,
      5,
      0,
      NULL,
      2.363654,
      NULL,
      1.474802,
      3);
commit;
end;
/


