set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '4200004',
      9,
      3,
      1.202931,
      2,
      '310331',
      3,
      NULL,
      4,
      NULL,
      0.403273,
      NULL,
      5.968643,
      3,
      1.077214,
      0.389348,
      3,
      1,
      0,
      NULL,
      NULL,
      1.327783,
      1.166312,
      0.692178,
      1,
      0,
      2,
      1.149770,
      1.396660,
      1.831408,
      NULL,
      NULL,
      0,
      1,
      4,
      0,
      5,
      0.197534,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.284751,
      1,
      2.548303,
      1,
      1.331159,
      2,
      1,
      0.424780,
      1,
      0,
      NULL,
      0,
      NULL,
      1.360552,
      0,
      1.870496,
      0.585409,
      1.518473,
      1,
      1,
      NULL,
      2.167431,
      NULL,
      0,
      0.700038,
      1.931963,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.223423,
      1,
      NULL,
      4,
      0.830438,
      NULL,
      NULL,
      0.446216,
      1,
      0.141638,
      2.368730,
      0,
      1.749281,
      0,
      0,
      0.105927,
      NULL,
      1,
      NULL,
      5.938859,
      1,
      4,
      0.322385,
      NULL,
      0,
      5.464766,
      3,
      1,
      7.771934,
      1,
      0,
      2,
      NULL,
      6,
      8.067547,
      5,
      5,
      3,
      2,
      NULL,
      0,
      3.953400,
      3.350694,
      3,
      NULL,
      2.818416,
      0.861930,
      NULL,
      4.195545,
      1.107900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945080,
      0.315157,
      1,
      1,
      0,
      1.256387,
      1.469341,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293927,
      NULL,
      NULL,
      NULL,
      NULL,
      3.794664,
      2.514563,
      3.473296,
      0,
      NULL,
      NULL,
      7.140693,
      NULL,
      0.021595,
      NULL,
      NULL,
      NULL,
      3.544063,
      0,
      5,
      NULL,
      0.890017,
      0,
      3.116059,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.091655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.018246,
      3.321109,
      1,
      NULL,
      NULL,
      0.372800,
      2.833281,
      NULL,
      NULL,
      1.816008,
      NULL,
      0,
      1.430458,
      1.784012,
      NULL,
      0,
      0.995557,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.149990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.970999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.096787,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.640644,
      '11400',
      '',
      '',
      NULL,
      '04013',
      '',
      '',
      0.999264,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


