set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '0111314',
      7,
      6,
      3,
      3,
      '310133',
      3,
      ' 0-25-1974',
      NULL,
      NULL,
      1,
      NULL,
      1.926152,
      2,
      NULL,
      1.285968,
      0.400097,
      NULL,
      1.909140,
      0.509710,
      NULL,
      1,
      4,
      1.974261,
      0.774415,
      1.002514,
      2,
      0.874832,
      5.149275,
      0,
      NULL,
      NULL,
      1.369898,
      NULL,
      0,
      1,
      1.467234,
      1,
      0.449607,
      0.919132,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      1.649713,
      NULL,
      3,
      NULL,
      2.152126,
      1,
      1,
      0.982400,
      0,
      2,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      1.350187,
      2.014772,
      6,
      1,
      1,
      NULL,
      1.263480,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.518092,
      2.458891,
      0.871957,
      0.901967,
      3,
      NULL,
      2.021146,
      0,
      1.857937,
      NULL,
      NULL,
      0.053282,
      0.323972,
      7,
      0,
      0.162911,
      0.009612,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.007655,
      0,
      0.543303,
      1.565903,
      2.656421,
      0,
      3.687616,
      2,
      5.457717,
      NULL,
      1.960023,
      1.738986,
      2,
      1,
      2.906995,
      0,
      7.291898,
      4.839001,
      4,
      1.897149,
      7.393972,
      7,
      1.837140,
      NULL,
      1.949405,
      3.422500,
      0.233032,
      1.654296,
      1.724923,
      8.874755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971222,
      0,
      0,
      1.310888,
      0.677412,
      1.375279,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.839329,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.851500,
      0.053706,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.690040,
      1,
      1,
      4.806670,
      1,
      NULL,
      NULL,
      1,
      1.468577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.033946,
      NULL,
      NULL,
      0.041359,
      0.948229,
      1,
      2,
      1.957120,
      3.200088,
      NULL,
      0,
      0.463733,
      1,
      0,
      0.401634,
      1,
      1,
      0.202191,
      0.929567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.709057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119687,
      1,
      NULL,
      NULL,
      NULL,
      0.063162,
      NULL,
      2,
      NULL,
      '31221',
      NULL,
      '',
      NULL,
      '00410',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


