set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-12-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '04',
      NULL,
      10.876854,
      '2400422',
      34,
      3,
      2,
      0,
      '021032',
      4,
      ' 6- 6-1976',
      1.956564,
      11,
      1,
      NULL,
      3.940986,
      NULL,
      1.832865,
      0.761399,
      0,
      1.083273,
      0,
      1,
      0.158073,
      0.243933,
      5.723869,
      1.844823,
      1.340717,
      NULL,
      4.731427,
      0.621452,
      4.217896,
      2.198109,
      0.001284,
      2,
      NULL,
      0.618175,
      0.023094,
      0,
      NULL,
      0.360758,
      NULL,
      1.478194,
      NULL,
      NULL,
      0.382296,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.108984,
      NULL,
      2,
      3.847284,
      NULL,
      0,
      2,
      1,
      1.576049,
      2.225019,
      0.463181,
      0,
      2,
      1,
      NULL,
      1,
      2,
      1.877612,
      1.747711,
      1,
      0,
      1,
      0.248986,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      2.677371,
      NULL,
      6,
      0,
      0.475869,
      1,
      0.768733,
      1.385323,
      NULL,
      NULL,
      1.328899,
      0,
      1.258636,
      0,
      1,
      NULL,
      1.598770,
      3,
      8.440486,
      1.885963,
      4,
      NULL,
      0.602046,
      0,
      4.924033,
      6.106285,
      NULL,
      NULL,
      0,
      NULL,
      0.746950,
      1,
      8.130262,
      9,
      9.708610,
      5.112937,
      NULL,
      5.244607,
      2,
      NULL,
      9.057952,
      1.921300,
      4.608164,
      6,
      3.748573,
      0.051564,
      0.646768,
      NULL,
      0.704010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483706,
      0,
      1,
      2,
      NULL,
      NULL,
      0.535343,
      1.812230,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.836648,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.631889,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.644264,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      4.767174,
      1.141129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      1.847253,
      NULL,
      0,
      1,
      0.850325,
      NULL,
      NULL,
      1.916196,
      0,
      1,
      NULL,
      NULL,
      0.673076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.366415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.148627,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2.846278,
      '22310',
      NULL,
      '',
      2.305476,
      '13144',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


