set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '44',
      23,
      25.857112,
      '0002442',
      11,
      2,
      3.956579,
      3,
      '430420',
      3.933839,
      NULL,
      39.455522,
      139,
      0.274112,
      NULL,
      0.603748,
      3.833770,
      0.766042,
      0.474919,
      NULL,
      0.276779,
      1,
      0.718133,
      1,
      0.719904,
      2.748518,
      1.216790,
      NULL,
      0.865143,
      NULL,
      2.336651,
      6,
      2.410477,
      0,
      0.523297,
      1.577173,
      0.852388,
      4.211123,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.391811,
      0,
      1,
      2.581842,
      NULL,
      0,
      1.308523,
      2.638978,
      1.983651,
      0.904081,
      1.685205,
      0.495725,
      NULL,
      1.810252,
      0,
      NULL,
      1.461092,
      0,
      1.068211,
      NULL,
      0.883025,
      1,
      5,
      NULL,
      NULL,
      1.017065,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      1.817615,
      0,
      3.030656,
      NULL,
      NULL,
      1,
      1.499501,
      1.145698,
      1.287749,
      4.537635,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.859883,
      NULL,
      0.458823,
      0.236064,
      7.449699,
      3.514283,
      3,
      1.048014,
      9,
      0,
      0.502359,
      1,
      3,
      NULL,
      1.163328,
      1,
      1.977202,
      1,
      NULL,
      10.830960,
      3.492254,
      3.304618,
      4.570776,
      1.607280,
      7,
      NULL,
      NULL,
      NULL,
      1.474500,
      7,
      0,
      0,
      0,
      NULL,
      1.584349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.041893,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.977455,
      2.569703,
      1.003522,
      NULL,
      NULL,
      NULL,
      3.006175,
      1.027568,
      1.056724,
      1.216553,
      NULL,
      0,
      0.810777,
      0.643594,
      NULL,
      NULL,
      NULL,
      0,
      1.896385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.508494,
      NULL,
      2.128503,
      NULL,
      2.695153,
      1.695378,
      NULL,
      NULL,
      2,
      NULL,
      1.166354,
      NULL,
      1.737421,
      1.002825,
      0.901255,
      0,
      0.744623,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399535,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190507,
      NULL,
      NULL,
      NULL,
      NULL,
      3.838681,
      0.933840,
      0,
      NULL,
      0.823228,
      0.284514,
      0,
      2,
      3.735475,
      NULL,
      '',
      NULL,
      3.584586,
      '33101',
      '',
      NULL,
      1.517432,
      '',
      '',
      '',
      0.831736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


