set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      NULL,
      1.038260,
      20,
      '3301004',
      35,
      1,
      NULL,
      0,
      '212141',
      4,
      ' 0- 3-1990',
      27,
      23,
      1,
      NULL,
      0.114672,
      3,
      1.549220,
      0,
      2,
      0,
      1.205333,
      0.735352,
      1,
      0.496717,
      3,
      0,
      0.735764,
      NULL,
      5.057006,
      0.466181,
      0.509009,
      1.758331,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      4,
      1.257593,
      0,
      1.389484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096099,
      NULL,
      NULL,
      1.819197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023019,
      0,
      0,
      1,
      1.106630,
      5.087979,
      3.158383,
      NULL,
      1,
      NULL,
      0,
      1,
      1.165158,
      4,
      1.280014,
      1.453753,
      0.051970,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.872743,
      0,
      0,
      6,
      1.175970,
      0.928473,
      0,
      3,
      2.212796,
      1,
      1,
      0.788602,
      2.296520,
      NULL,
      5,
      7.310341,
      4.254107,
      0.563984,
      0,
      5.216966,
      0.771299,
      3.554691,
      1,
      2.183995,
      4,
      2.094175,
      0.184419,
      NULL,
      NULL,
      0.339187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484281,
      0,
      NULL,
      0,
      0.761525,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204009,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.163730,
      0,
      0.649014,
      NULL,
      NULL,
      NULL,
      0.439995,
      NULL,
      3.366450,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971035,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.129947,
      NULL,
      1,
      0,
      2,
      NULL,
      3.377267,
      0,
      NULL,
      2.753071,
      0,
      1.261121,
      0,
      1.371493,
      1.323212,
      1,
      NULL,
      0.422762,
      0.867873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.978736,
      0.981656,
      2,
      1.768344,
      '04404',
      NULL,
      '',
      NULL,
      '40341',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


