set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '44',
      15,
      27,
      '4433401',
      56,
      4,
      0.340537,
      3,
      '141323',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571050,
      NULL,
      NULL,
      0.025456,
      1.016599,
      0.999933,
      1.503235,
      NULL,
      1,
      5.879249,
      0,
      NULL,
      3.202527,
      3.169859,
      0.331662,
      7,
      1.023516,
      5,
      0,
      NULL,
      0,
      3.026499,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.796611,
      NULL,
      NULL,
      2,
      1.780557,
      3.748308,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.599182,
      1.701385,
      3,
      3.640592,
      0,
      0,
      1.101721,
      0,
      0,
      0,
      5,
      0,
      0.487855,
      NULL,
      0.996166,
      1.260057,
      NULL,
      0,
      0.455654,
      NULL,
      NULL,
      1.005562,
      0,
      0,
      0.762813,
      5,
      4,
      5,
      NULL,
      NULL,
      1.064206,
      NULL,
      2,
      NULL,
      1,
      2.654113,
      6.990270,
      2.983397,
      3.925464,
      1,
      5,
      NULL,
      1.678484,
      3.430433,
      5.198721,
      NULL,
      NULL,
      NULL,
      8.582051,
      1.644824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062752,
      0,
      1,
      0,
      1.984115,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.698398,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.323936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551739,
      1.993104,
      NULL,
      0.489697,
      NULL,
      0,
      1,
      3,
      0.257589,
      NULL,
      2.010035,
      0.489369,
      1,
      0,
      NULL,
      0,
      0,
      0.762328,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.735231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.340566,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.800789,
      NULL,
      NULL,
      NULL,
      0.836118,
      NULL,
      0.867009,
      NULL,
      0.938720,
      '23110',
      NULL,
      '',
      0,
      '02342',
      '',
      '',
      0,
      NULL,
      '',
      '',
      2.123519,
      5.368502,
      0,
      0.755994,
      1,
      0,
      NULL,
      0.763858,
      NULL);
commit;
end;
/


