set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '011',
      '2',
      4,
      NULL,
      '4301204',
      5,
      2,
      1,
      0,
      NULL,
      2,
      NULL,
      51.281540,
      21,
      1,
      NULL,
      0,
      3,
      0.659425,
      1.878875,
      3,
      1,
      1.830261,
      0,
      1,
      1.772663,
      1,
      0.174820,
      NULL,
      0,
      3,
      1,
      2,
      1,
      3,
      NULL,
      1,
      1,
      1.476424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.261299,
      NULL,
      1.740022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782663,
      NULL,
      1.837835,
      1.530457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596699,
      NULL,
      4.372540,
      0.985632,
      5,
      1,
      NULL,
      NULL,
      1.880914,
      1.791689,
      NULL,
      1,
      1.745264,
      3,
      1.572186,
      0,
      1,
      0.644105,
      0,
      NULL,
      1,
      0,
      7.619363,
      0,
      NULL,
      1.145269,
      NULL,
      0,
      1,
      1.152113,
      NULL,
      3,
      0,
      0,
      5.569832,
      NULL,
      0,
      7,
      NULL,
      NULL,
      2,
      3.090184,
      5,
      4,
      4.596890,
      3,
      NULL,
      1.772116,
      0,
      NULL,
      NULL,
      6,
      0.163286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620690,
      0.189454,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.142937,
      1.810859,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.311236,
      NULL,
      NULL,
      NULL,
      3.367672,
      0.370079,
      1,
      0,
      1,
      2,
      0.548871,
      NULL,
      NULL,
      NULL,
      1.434684,
      6.037225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.040529,
      1.837755,
      0,
      NULL,
      2.885719,
      0,
      2.972312,
      0,
      NULL,
      0,
      1,
      0.108705,
      1,
      0,
      1.815212,
      NULL,
      0.196069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.053810,
      1.418479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.694338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.878990,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      0,
      1.662403,
      1,
      0,
      3,
      '31033',
      NULL,
      '',
      1.298363,
      '04320',
      '',
      NULL,
      1.366417,
      '',
      NULL,
      '',
      4,
      0,
      3,
      NULL,
      NULL,
      2,
      0.352795,
      3.460893,
      NULL);
commit;
end;
/


