set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '43122422',
      44.346572,
      59.442627,
      NULL,
      NULL,
      6,
      NULL,
      2,
      '432132',
      1.654756,
      ' 0-25-1998',
      15.610348,
      3,
      1.206864,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      0.761262,
      NULL,
      0.772158,
      0,
      1,
      1,
      1.446759,
      NULL,
      0.495381,
      NULL,
      0.393517,
      1,
      1,
      NULL,
      0.755164,
      5,
      0,
      NULL,
      0,
      1.531112,
      NULL,
      NULL,
      NULL,
      1.695647,
      NULL,
      NULL,
      NULL,
      3.053705,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.743651,
      0.217986,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.510568,
      1.019655,
      0.790564,
      NULL,
      0.381206,
      0.481011,
      NULL,
      NULL,
      0,
      1.828551,
      1,
      1.967248,
      NULL,
      NULL,
      0,
      0.170161,
      1,
      1,
      NULL,
      NULL,
      0.637341,
      NULL,
      3.179388,
      1.482815,
      NULL,
      1.209299,
      4,
      1,
      NULL,
      3,
      1.917965,
      5,
      0,
      1.648333,
      0,
      1,
      1.499069,
      2.341274,
      0.716523,
      NULL,
      NULL,
      2.431248,
      3.743095,
      1.135784,
      4,
      7,
      5.947636,
      NULL,
      0.826368,
      NULL,
      NULL,
      8.380141,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773375,
      1,
      0,
      1,
      0.859646,
      0.269476,
      2.693862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165434,
      NULL,
      NULL,
      NULL,
      NULL,
      5.661973,
      3,
      2.022086,
      1,
      1,
      2.561537,
      NULL,
      2.756535,
      0.766313,
      NULL,
      NULL,
      NULL,
      0.054039,
      1.795598,
      3.485402,
      4.268684,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.490768,
      0.968361,
      0,
      0.029799,
      3,
      2.639767,
      0.210538,
      0,
      1.649344,
      0.132541,
      0,
      0,
      1,
      NULL,
      0,
      1.938921,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.168345,
      1.740011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457885,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.080859,
      NULL,
      NULL,
      0.130588,
      1,
      1,
      0.577575,
      '04143',
      NULL,
      '',
      1.329475,
      '40400',
      '',
      '',
      1.827122,
      '',
      '',
      '',
      2,
      3.179141,
      2,
      2,
      NULL,
      2.103096,
      NULL,
      3,
      1);
commit;
end;
/


