set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '24213143',
      NULL,
      59.015117,
      '4304032',
      140.865701,
      6,
      2.964584,
      2,
      '312313',
      5,
      NULL,
      38.305474,
      28,
      0.199767,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.774627,
      1,
      0,
      1.378072,
      0,
      NULL,
      1.029216,
      0,
      1.277915,
      1,
      0,
      NULL,
      0.339814,
      1,
      0,
      NULL,
      0,
      0.229034,
      1.826248,
      3.272016,
      1.467591,
      NULL,
      NULL,
      1.284972,
      NULL,
      NULL,
      1.698795,
      1,
      NULL,
      0.478977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175334,
      1.709594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232090,
      2.710547,
      3,
      NULL,
      NULL,
      0,
      0.661708,
      1.711000,
      0.678918,
      NULL,
      0.669517,
      1.854375,
      NULL,
      0,
      1,
      0,
      0.227865,
      1.379809,
      NULL,
      NULL,
      1.791155,
      4.665740,
      7.163089,
      1,
      0.500931,
      1.671127,
      4,
      0.478956,
      3.354923,
      1.483735,
      2.063473,
      NULL,
      3.885901,
      0.051840,
      NULL,
      1,
      0,
      NULL,
      2,
      7,
      4,
      5.983695,
      2.730366,
      1,
      4.783635,
      NULL,
      0,
      2.351844,
      NULL,
      NULL,
      NULL,
      8,
      0.509519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.208177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.235189,
      0.197089,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466040,
      4.255185,
      NULL,
      1,
      0,
      0.722906,
      NULL,
      NULL,
      NULL,
      0.660409,
      2,
      1.215783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820809,
      NULL,
      1.459133,
      1.387844,
      1.448830,
      2,
      NULL,
      NULL,
      0,
      1,
      0.782345,
      NULL,
      NULL,
      1.661323,
      1,
      1,
      0.190473,
      1.729988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '20300',
      '',
      '',
      3,
      '41144',
      '',
      '',
      0.352209,
      NULL,
      '',
      NULL,
      2,
      5.765161,
      NULL,
      2,
      2.455990,
      1.011805,
      1.168464,
      1.601525,
      3);
commit;
end;
/


