set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9514251';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1112',
      '11431232',
      78.831614,
      NULL,
      '3100044',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      ' 7- 3-2003',
      NULL,
      16.904979,
      0,
      NULL,
      2,
      1.947173,
      0.256879,
      0.134792,
      0,
      1,
      1.249789,
      0.176106,
      1.530364,
      1.293899,
      NULL,
      0,
      0.183102,
      1,
      1,
      1.885533,
      NULL,
      1.782300,
      3,
      0.207629,
      1,
      1.612328,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.336700,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032345,
      1,
      1.760257,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507739,
      0.268208,
      1,
      NULL,
      1.322306,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.161679,
      NULL,
      NULL,
      1,
      0,
      0.484605,
      0,
      NULL,
      1.368459,
      0.881755,
      1,
      0.586046,
      2,
      NULL,
      1.452808,
      1.623122,
      NULL,
      NULL,
      3.830478,
      NULL,
      NULL,
      1,
      1.540841,
      1,
      0,
      5,
      5.880467,
      2,
      0,
      5,
      2.057170,
      0,
      3,
      1.645803,
      4.875507,
      3.070581,
      0,
      NULL,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.437115,
      0,
      0,
      0.299745,
      1,
      1.143262,
      1.558773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536056,
      NULL,
      NULL,
      NULL,
      NULL,
      0.024040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.015222,
      0.799971,
      NULL,
      NULL,
      NULL,
      2,
      0.780935,
      4.240878,
      2.108219,
      1.672871,
      0,
      1.047049,
      NULL,
      NULL,
      NULL,
      0.357660,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.158126,
      0,
      NULL,
      1,
      NULL,
      0.187067,
      0,
      0,
      1,
      1.990848,
      0,
      0,
      1,
      1,
      NULL,
      1.387047,
      1.600710,
      1,
      0.067101,
      0.603212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.687621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689561,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912724,
      NULL,
      NULL,
      NULL,
      NULL,
      2.966479,
      NULL,
      1,
      NULL,
      0.053555,
      0.754131,
      1,
      2,
      3,
      '43401',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0.749722,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      1.912403,
      NULL,
      3,
      0,
      0.191810,
      NULL);
commit;
end;
/


