set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '121',
      '20',
      0,
      13,
      '2134222',
      108.589159,
      1,
      NULL,
      NULL,
      '123241',
      1,
      ' 8-16-1974',
      18,
      31.141835,
      0.611374,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.808229,
      3.765187,
      0.522990,
      0.418739,
      NULL,
      0,
      1.203982,
      0,
      1.564039,
      NULL,
      1.994039,
      1.979413,
      1.468278,
      1.854872,
      1,
      1.256711,
      0,
      NULL,
      1.973678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.161286,
      0.283998,
      1.587945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863690,
      1.930128,
      0.167693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.922994,
      1.405451,
      1,
      1,
      0.616411,
      1.653046,
      0.208167,
      1,
      0.593696,
      1,
      0.780790,
      0,
      0.538292,
      1.856845,
      0,
      0,
      1.353791,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.394240,
      0.787214,
      3,
      NULL,
      4,
      1,
      2,
      NULL,
      1,
      NULL,
      0,
      0.829865,
      0.445169,
      0.705732,
      6,
      9,
      NULL,
      8.715268,
      NULL,
      4.098892,
      5.010753,
      1,
      1.793252,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177646,
      1,
      1,
      0,
      NULL,
      1,
      1.135180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6.120665,
      3.281760,
      0.336560,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3.622965,
      0,
      4.502777,
      1,
      NULL,
      NULL,
      0.024931,
      1.601338,
      0.500005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294504,
      NULL,
      0,
      1,
      1.762894,
      0.565679,
      1.287247,
      3.545822,
      1,
      2.513445,
      3,
      NULL,
      0.026891,
      0.856483,
      1,
      1,
      1.550351,
      0.504105,
      0.236327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.309203,
      '4002',
      '',
      '',
      3.171459,
      '44024',
      '',
      '',
      1,
      '',
      '',
      '',
      5.810757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


