set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '01022233',
      43,
      NULL,
      '0214420',
      52.608530,
      3,
      1,
      1,
      '443214',
      1.765685,
      ' 7-20-1999',
      47.308922,
      43,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.950674,
      0,
      1,
      1,
      1,
      0,
      0.401740,
      1.664607,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.234254,
      0.351779,
      1.927881,
      1.096845,
      0,
      0,
      1.301338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.438575,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298320,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.393240,
      1,
      0,
      0,
      0.848627,
      1,
      1.817504,
      0,
      0,
      0.119695,
      1,
      1.134861,
      1,
      0,
      NULL,
      0.280358,
      NULL,
      1.420740,
      0.947582,
      NULL,
      1.583296,
      NULL,
      0,
      0,
      NULL,
      0.752506,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.994079,
      0.634214,
      1.254221,
      2.691594,
      9.590740,
      3.021310,
      6.558585,
      4,
      2.818207,
      6.777379,
      0,
      6.755069,
      1.942488,
      0,
      1.831117,
      0,
      NULL,
      NULL,
      4,
      1.874130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542443,
      1,
      0,
      0.524936,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.626446,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.084478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355888,
      7,
      7.578399,
      NULL,
      NULL,
      1.835031,
      NULL,
      NULL,
      NULL,
      0.819279,
      7,
      0.910004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858113,
      0,
      2,
      1,
      3,
      1.395826,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.524833,
      1.914538,
      0.654452,
      0,
      1.980050,
      1.374926,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '2410',
      '',
      '',
      NULL,
      '43344',
      '',
      '',
      0.197544,
      '',
      NULL,
      NULL,
      1.367486,
      0.382836,
      0.023274,
      3.240466,
      3,
      2.445005,
      NULL,
      2,
      2);
commit;
end;
/


