set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '20422424',
      NULL,
      15.664434,
      '1444303',
      NULL,
      5,
      NULL,
      2,
      '414210',
      NULL,
      ' 5-15-1986',
      54.337536,
      49,
      0.078374,
      NULL,
      NULL,
      0.664776,
      NULL,
      NULL,
      NULL,
      1.931806,
      1,
      0,
      3.282167,
      0.756308,
      NULL,
      1.801168,
      1,
      0.817374,
      1.096772,
      NULL,
      1.124291,
      0.082988,
      1,
      1,
      1.496867,
      1.252942,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.024824,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545708,
      0.401954,
      1.539767,
      1.546392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593142,
      1.157644,
      1.251954,
      NULL,
      1.438070,
      NULL,
      NULL,
      1.514386,
      1,
      1.897953,
      1,
      1,
      1.513758,
      0,
      NULL,
      NULL,
      NULL,
      0.311171,
      0,
      NULL,
      1.094259,
      NULL,
      0.103837,
      NULL,
      0,
      1.930193,
      5.711607,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237888,
      0,
      3,
      0.012755,
      6.566586,
      8.721556,
      3,
      5.650975,
      2,
      5,
      1.396123,
      NULL,
      11,
      2.910923,
      1.846340,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958519,
      0,
      0,
      0,
      0.071073,
      1.030033,
      1,
      1.163340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.346165,
      NULL,
      9.110834,
      0,
      0.572409,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      0.828603,
      NULL,
      NULL,
      NULL,
      NULL,
      1.943694,
      NULL,
      9.009560,
      5.674286,
      2,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.102073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.446887,
      0,
      2,
      0,
      3,
      NULL,
      0,
      2.898701,
      1,
      3,
      1.493479,
      1.232905,
      NULL,
      1,
      NULL,
      0,
      0,
      1.660988,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '4240',
      '',
      '',
      3.088537,
      NULL,
      NULL,
      NULL,
      1.069199,
      '',
      '',
      '',
      NULL,
      4,
      2,
      0,
      2.862259,
      1,
      1,
      3,
      2.521120);
commit;
end;
/


