set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9119514';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      16,
      60,
      '1340433',
      NULL,
      4,
      1,
      2,
      '022303',
      3.554514,
      NULL,
      43.618892,
      49,
      1.749541,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.273862,
      1,
      1.102797,
      0,
      0.180713,
      NULL,
      1.619516,
      1.513519,
      NULL,
      0,
      NULL,
      0,
      0.511878,
      0,
      0.685705,
      NULL,
      0.453603,
      NULL,
      0.420696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842502,
      1,
      1.302986,
      0.961162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202003,
      NULL,
      0,
      0.713404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388167,
      0.964982,
      1,
      1,
      0.902135,
      1.591923,
      1.552969,
      NULL,
      0.804636,
      NULL,
      1.138869,
      1.741155,
      1,
      0.439500,
      1.153269,
      0.634102,
      1,
      NULL,
      1,
      NULL,
      1.722772,
      NULL,
      NULL,
      1,
      3,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.543619,
      3,
      3.205022,
      0.027648,
      2,
      NULL,
      8.539312,
      NULL,
      NULL,
      2.914553,
      NULL,
      9,
      NULL,
      5.827006,
      0.242868,
      4,
      1.815899,
      NULL,
      NULL,
      3.338498,
      0.491116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.415472,
      0.101429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.345087,
      NULL,
      NULL,
      1,
      NULL,
      3.067068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.025931,
      NULL,
      5,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      1,
      6,
      0.744010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.446466,
      NULL,
      3.748535,
      0,
      2,
      3,
      2,
      2.259972,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.279063,
      0,
      1.632359,
      1.960909,
      0.362569,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '0302',
      '',
      '',
      1.195738,
      '02202',
      '',
      '',
      0,
      '',
      '',
      '',
      2.455515,
      0.783049,
      NULL,
      2.180686,
      3.804984,
      0.454069,
      1,
      2,
      2.526735);
commit;
end;
/


