set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '434',
      '34444434',
      55,
      45.973640,
      NULL,
      NULL,
      1,
      2.044293,
      3,
      '114403',
      0,
      NULL,
      179.218991,
      25,
      1,
      NULL,
      1.157017,
      2,
      1,
      0,
      1,
      NULL,
      0.706128,
      1.227478,
      NULL,
      NULL,
      6,
      0,
      1.240059,
      NULL,
      0.629036,
      0.215484,
      NULL,
      4,
      1.379058,
      0.386384,
      4,
      1,
      7,
      NULL,
      0.431043,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.255506,
      0.231469,
      0,
      3.345520,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.697251,
      0,
      1.877536,
      5.857091,
      NULL,
      1,
      1.831981,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      3,
      0.883672,
      0,
      5,
      5.003387,
      0.044945,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5.665327,
      1,
      NULL,
      1.407989,
      1,
      0,
      NULL,
      1.257015,
      NULL,
      0.784348,
      2.100982,
      1,
      0.158271,
      1,
      1.846896,
      2,
      0,
      4,
      0.786309,
      0.577690,
      0.609426,
      NULL,
      3,
      NULL,
      NULL,
      4,
      9.411047,
      4.833930,
      3,
      5,
      5,
      7,
      4.796443,
      1.048677,
      5,
      1.551315,
      5,
      0,
      1,
      1.072133,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409959,
      1,
      0,
      0,
      1,
      4,
      0.039027,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.472847,
      0,
      NULL,
      2.145704,
      2,
      6,
      0.980366,
      2.008015,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3.864035,
      NULL,
      4.917715,
      1,
      1.296067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440023,
      NULL,
      4,
      0.426235,
      6.096522,
      0,
      1,
      3.471881,
      3,
      3,
      NULL,
      1.533642,
      3.309397,
      NULL,
      2,
      0,
      1,
      1,
      1.965616,
      1,
      0.466604,
      1.162933,
      0,
      1,
      0.869301,
      NULL,
      0.219655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.620184,
      '22333',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.278582,
      4.055081,
      5,
      3.032695,
      1.679196,
      3,
      NULL,
      3,
      2);
commit;
end;
/


