set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '22204321',
      44,
      6.839292,
      '3331301',
      44,
      4,
      1,
      NULL,
      '034423',
      NULL,
      ' 1- 1-1987',
      226,
      76,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.720348,
      1.280700,
      NULL,
      0,
      2.834462,
      0,
      0.926221,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.259092,
      8,
      NULL,
      NULL,
      0.468610,
      0.730901,
      0,
      NULL,
      1,
      1.609038,
      3.480233,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.514645,
      1.227016,
      1,
      0.670548,
      1.218646,
      0.966219,
      0.623554,
      0,
      NULL,
      1,
      2,
      NULL,
      0.748487,
      NULL,
      2,
      0.772698,
      NULL,
      NULL,
      1,
      6.061588,
      0,
      0,
      1.909487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.513391,
      NULL,
      NULL,
      1.275762,
      3,
      NULL,
      2,
      1.020997,
      1.894113,
      1,
      0.923683,
      5.740152,
      0.659476,
      2,
      0,
      0,
      NULL,
      0.235919,
      NULL,
      NULL,
      1.240215,
      NULL,
      0,
      0.537632,
      3,
      0.856761,
      1,
      NULL,
      0.180363,
      3.384214,
      NULL,
      1.719069,
      2,
      5,
      4.845255,
      NULL,
      5,
      NULL,
      NULL,
      9.897837,
      6,
      9,
      7,
      8,
      6.242126,
      5,
      NULL,
      2.109553,
      2.293092,
      NULL,
      0.874165,
      0.979192,
      1.701809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.119844,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.537877,
      0,
      1.636685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.542495,
      1.916159,
      1,
      NULL,
      NULL,
      NULL,
      0.059285,
      4,
      2.382814,
      NULL,
      2.574384,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.344600,
      3.204758,
      0.994202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1.105087,
      0,
      0,
      3,
      0,
      NULL,
      0.251059,
      0.963775,
      1.611141,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.627414,
      '31100',
      NULL,
      NULL,
      1.165388,
      '',
      '',
      NULL,
      0.072718,
      '',
      '',
      '',
      2.782229,
      2.011136,
      5,
      6,
      2,
      6,
      4,
      NULL,
      1);
commit;
end;
/


