set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1423',
      '23021223',
      77.200486,
      80.353321,
      '3341102',
      4.948731,
      6,
      2,
      NULL,
      '134324',
      0,
      NULL,
      86,
      87,
      0,
      NULL,
      1.452874,
      2.496983,
      0.739885,
      0.187513,
      1.791673,
      0.007526,
      1.401378,
      2,
      0,
      NULL,
      3,
      0.286763,
      NULL,
      0.723373,
      1,
      2.550339,
      2,
      1,
      3,
      0,
      0.608021,
      0.289508,
      5.102106,
      0,
      3.451397,
      0.288076,
      0,
      0,
      NULL,
      NULL,
      0.625393,
      NULL,
      NULL,
      1,
      0,
      0,
      3,
      1.803438,
      1.307444,
      NULL,
      0.749428,
      1.285420,
      3.566933,
      1,
      NULL,
      0,
      2.722083,
      0.442184,
      NULL,
      NULL,
      1.500722,
      1,
      NULL,
      0,
      NULL,
      8.306685,
      NULL,
      1,
      0.429139,
      0,
      NULL,
      NULL,
      0.410801,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.007014,
      3.393807,
      1.628705,
      5,
      1.191287,
      0.100895,
      1.679318,
      0,
      2,
      0.033842,
      1.716075,
      0.797939,
      0,
      0,
      1.426152,
      1,
      NULL,
      1,
      NULL,
      0,
      1.025731,
      NULL,
      1.039797,
      0.558605,
      0.751975,
      NULL,
      0,
      0.387943,
      0,
      NULL,
      1.803935,
      NULL,
      2.622480,
      3.637830,
      NULL,
      4.045387,
      NULL,
      NULL,
      NULL,
      NULL,
      8.324330,
      1.718858,
      NULL,
      1.536831,
      5.809369,
      1,
      NULL,
      0.754013,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164727,
      0,
      0,
      0,
      0,
      NULL,
      2,
      1.954578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.804365,
      NULL,
      4,
      1.614978,
      0.268727,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537328,
      2,
      0.706554,
      0.312863,
      1,
      0.315078,
      0.674622,
      1.258783,
      3,
      3.328643,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.812872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.262557,
      3,
      0,
      NULL,
      0.919275,
      0.202991,
      0.796644,
      2.019008,
      0,
      NULL,
      1,
      0,
      1,
      1.431278,
      0.553680,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.705541,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      5,
      5,
      3.381636,
      3.953388,
      4,
      2,
      1,
      1.304342,
      1.343493);
commit;
end;
/


