set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9784058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2010',
      NULL,
      NULL,
      18,
      NULL,
      39,
      5,
      2.114463,
      NULL,
      NULL,
      2.305840,
      NULL,
      NULL,
      13.419168,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.690165,
      NULL,
      0,
      0.867914,
      0,
      0,
      0.401363,
      0.985930,
      0,
      NULL,
      0.966187,
      0.313205,
      3.760089,
      NULL,
      NULL,
      6.125616,
      NULL,
      1.588469,
      NULL,
      3,
      NULL,
      5,
      1,
      3.184530,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015631,
      0,
      0,
      0.005359,
      2,
      0,
      1,
      1.573685,
      2.828419,
      1.633228,
      0,
      2,
      NULL,
      1.910955,
      1,
      0,
      NULL,
      3.420982,
      NULL,
      0,
      6,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.767658,
      NULL,
      3,
      4.494263,
      1.116217,
      2,
      0.128331,
      NULL,
      1.333597,
      NULL,
      2.411435,
      NULL,
      5.336287,
      NULL,
      1,
      NULL,
      1.582264,
      0.325063,
      NULL,
      0,
      NULL,
      1.257371,
      3.489704,
      0,
      0,
      4,
      0.665556,
      1.373991,
      NULL,
      1.286610,
      0,
      NULL,
      7.289108,
      3.920608,
      2,
      7,
      9,
      7.552825,
      6,
      4.363571,
      NULL,
      3,
      9,
      NULL,
      1,
      1,
      3,
      0,
      0.427997,
      NULL,
      6.851222,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.332795,
      0,
      NULL,
      1.594515,
      4.668028,
      2.927845,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.527172,
      NULL,
      0,
      2,
      1.823818,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.094697,
      NULL,
      3,
      2.758844,
      NULL,
      3.366023,
      5,
      5,
      4.551303,
      NULL,
      1.404431,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.151819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2,
      0.864490,
      NULL,
      2,
      1,
      1,
      0.649946,
      0.734342,
      NULL,
      0,
      1.128663,
      0.595098,
      0.209902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '01102',
      NULL,
      '',
      0.342206,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      4.684319,
      0,
      NULL,
      0.984200,
      3.566572,
      2.871929,
      NULL,
      3.903569,
      3.052181);
commit;
end;
/


