set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '124',
      NULL,
      33,
      0,
      '3130142',
      163,
      3,
      2.892717,
      3,
      '031001',
      5,
      ' 7-17-1985',
      0.400740,
      54.316407,
      0.816221,
      NULL,
      1,
      0.025377,
      1,
      0,
      0,
      1.059341,
      1.579400,
      3.329627,
      NULL,
      1.623267,
      2,
      0,
      0,
      NULL,
      0,
      0.799849,
      2,
      0.432924,
      1.404010,
      1.705714,
      NULL,
      0,
      1,
      1,
      1.962625,
      NULL,
      1.930904,
      0,
      NULL,
      NULL,
      0.032580,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.371491,
      2.858272,
      3,
      NULL,
      1.122160,
      1.073827,
      NULL,
      1,
      0.807429,
      3.944664,
      3,
      1,
      3.405485,
      1,
      0,
      0.664449,
      2,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1.833841,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.729180,
      0,
      0.666689,
      0,
      0.226681,
      0,
      0.147066,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.905321,
      0,
      1.476363,
      NULL,
      1.703536,
      5,
      5,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      4,
      3.391293,
      NULL,
      4.386671,
      4.673298,
      3,
      NULL,
      7.592291,
      1,
      0,
      NULL,
      3,
      0,
      4.383103,
      0.595314,
      NULL,
      NULL,
      4.474620,
      1.432438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1.806169,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.365789,
      1.755848,
      0.170857,
      NULL,
      NULL,
      NULL,
      0,
      1.508696,
      2.746223,
      NULL,
      1.121635,
      1,
      1.131619,
      NULL,
      NULL,
      NULL,
      1.024014,
      1.618234,
      0.857679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358663,
      3.242784,
      3.575161,
      NULL,
      NULL,
      3,
      0,
      0,
      1.306803,
      NULL,
      3,
      1.125997,
      NULL,
      NULL,
      0,
      0.022274,
      1,
      1,
      1,
      0.480302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.536780,
      NULL,
      '',
      '',
      0.331425,
      NULL,
      '',
      NULL,
      1.279757,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


