set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-4-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '44',
      38.834529,
      21,
      '4110123',
      42.104420,
      6,
      2,
      3,
      '204244',
      0.955054,
      ' 2- 3-1984',
      58.282736,
      85.884396,
      NULL,
      NULL,
      NULL,
      1,
      3.664896,
      0.399384,
      0,
      1.625006,
      1,
      NULL,
      0.399300,
      0.556964,
      3.286120,
      NULL,
      0,
      0.303111,
      0.650239,
      1.370015,
      5.748185,
      0,
      5,
      1,
      0.031475,
      1.138949,
      5.030993,
      NULL,
      0.192015,
      0.559717,
      0.291791,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.485534,
      1.955392,
      1,
      0.894289,
      1.402212,
      3,
      1,
      3.511152,
      NULL,
      1,
      1.637865,
      1.997451,
      NULL,
      1.166706,
      NULL,
      NULL,
      3.616738,
      NULL,
      1.332215,
      NULL,
      1.420879,
      4,
      1,
      1,
      1.077805,
      0,
      NULL,
      NULL,
      0.013246,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.469918,
      0.563905,
      5.383312,
      NULL,
      0,
      0.235664,
      0.819766,
      0,
      1,
      NULL,
      1,
      1,
      1.326723,
      1,
      NULL,
      NULL,
      1.849380,
      NULL,
      2,
      1.246216,
      0,
      0.218847,
      3.054326,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.045434,
      2.976811,
      1,
      5.574374,
      2,
      5,
      7.121181,
      6.242255,
      6.383298,
      0.848723,
      2,
      0.398508,
      1.929564,
      2,
      1.339864,
      NULL,
      NULL,
      4.433313,
      1.606971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.029557,
      0,
      0,
      0,
      0.869463,
      NULL,
      0.940486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481157,
      0.507373,
      NULL,
      NULL,
      1,
      2,
      1.482694,
      NULL,
      NULL,
      NULL,
      0,
      1.410883,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.914908,
      2.637188,
      3,
      0,
      1,
      0.157214,
      2.032454,
      NULL,
      1,
      1,
      0,
      1.811300,
      NULL,
      NULL,
      0.210338,
      0.832902,
      1.506598,
      0.347093,
      1.620778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111987,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.408899,
      NULL,
      1.503621,
      0.657586,
      1.815525,
      2,
      1,
      '44002',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.401698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


