set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1.195274,
      6,
      '2040221',
      192,
      1,
      1.205235,
      0,
      NULL,
      0.055277,
      ' 1-13-2003',
      20,
      43,
      1.983253,
      NULL,
      1.152742,
      0.536290,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1.358954,
      1.348951,
      3,
      1,
      0,
      1.393076,
      0.512296,
      0.291611,
      1,
      NULL,
      1,
      0,
      1.712024,
      NULL,
      1,
      0,
      0.041202,
      0,
      NULL,
      0.306389,
      NULL,
      NULL,
      1.552434,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.748315,
      1.282450,
      3,
      2,
      NULL,
      0.259476,
      1,
      3.159191,
      0.827918,
      0.787896,
      0.201300,
      2,
      NULL,
      3,
      0.162322,
      0.276764,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.818071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0.217930,
      1.690464,
      1,
      2.257005,
      1,
      0.569160,
      1.530802,
      0,
      0.241205,
      0,
      3,
      NULL,
      0.840109,
      NULL,
      NULL,
      1.057055,
      NULL,
      NULL,
      3,
      0,
      0,
      5,
      0,
      6,
      1.636394,
      1.787569,
      NULL,
      NULL,
      5.998539,
      1,
      0,
      NULL,
      NULL,
      0.330497,
      5,
      1.000915,
      7,
      6,
      2.136754,
      7.954829,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.099193,
      NULL,
      NULL,
      NULL,
      0.259691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653787,
      1,
      1,
      0,
      0.764322,
      0.297841,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.808361,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.448058,
      1.239195,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.407453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235780,
      1.123338,
      1.220807,
      0,
      0,
      1,
      1.897850,
      3,
      1,
      NULL,
      1,
      0,
      0,
      1.248810,
      0,
      0.935216,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '33224',
      '',
      NULL,
      1.408932,
      NULL,
      '',
      '',
      1.599026,
      '',
      '',
      '',
      2.267975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


