set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '43',
      0,
      34,
      '2214042',
      234,
      4,
      1.401385,
      0,
      '224040',
      1,
      ' 5- 0-2000',
      NULL,
      31,
      0.302009,
      NULL,
      0,
      0,
      0.320045,
      1.065504,
      1,
      NULL,
      1.038934,
      1,
      NULL,
      1.641269,
      0,
      1.174961,
      NULL,
      1.154914,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      0,
      0.441747,
      5,
      1,
      NULL,
      3.528725,
      1.891474,
      1,
      NULL,
      NULL,
      0.107360,
      NULL,
      NULL,
      3.616175,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.652462,
      2.941593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.216039,
      0.623226,
      1.324409,
      NULL,
      3.066033,
      NULL,
      1,
      0.451853,
      0,
      1,
      NULL,
      NULL,
      1.007748,
      NULL,
      0.562500,
      NULL,
      0,
      NULL,
      1.786628,
      3.510792,
      0,
      NULL,
      5.457519,
      0,
      6.702060,
      2.638872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.398707,
      1,
      1,
      5,
      0,
      3.349903,
      0,
      7.578589,
      5.840884,
      0,
      2.936345,
      1.734266,
      1.650463,
      NULL,
      NULL,
      0,
      0.418570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767326,
      0,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.175234,
      0,
      NULL,
      NULL,
      NULL,
      3.969682,
      1.486215,
      3,
      1.912871,
      NULL,
      NULL,
      0.419365,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.276191,
      1,
      0.229314,
      NULL,
      0,
      NULL,
      2,
      0,
      1.922842,
      3.434998,
      1,
      1.790584,
      0,
      1,
      1.965501,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327943,
      NULL,
      0,
      NULL,
      0.843591,
      2,
      1,
      '43433',
      NULL,
      NULL,
      1.386559,
      '',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      0.266031,
      2.486965,
      1.908805,
      NULL,
      2.787716,
      2.751299,
      NULL,
      3.364235);
commit;
end;
/


