set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '43313333',
      34,
      13,
      '0043201',
      151,
      6,
      2,
      0,
      '441332',
      5.020770,
      ' 2-12-1996',
      18.725077,
      24,
      NULL,
      NULL,
      1.976996,
      0,
      0,
      0.687876,
      NULL,
      0.096107,
      1,
      1,
      0,
      0.391817,
      0.497250,
      0.522707,
      1,
      1,
      0.314759,
      0.617206,
      1,
      NULL,
      0,
      1.965235,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.476025,
      NULL,
      NULL,
      0,
      5.415278,
      2,
      3.567856,
      1.045139,
      1.274067,
      2,
      2.695563,
      NULL,
      3.005315,
      1.229927,
      0.503691,
      0,
      2,
      1.144329,
      0,
      2.317121,
      3,
      0.950457,
      1.867177,
      NULL,
      0,
      1.479440,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.264435,
      0,
      0.079639,
      0.052619,
      5.168630,
      0.030588,
      1,
      NULL,
      0.659910,
      1.159710,
      1,
      0.044261,
      NULL,
      NULL,
      0.829424,
      0.456990,
      0,
      NULL,
      0.834112,
      0,
      3.015848,
      0.652376,
      4,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762373,
      0,
      NULL,
      0,
      2,
      NULL,
      7.824482,
      0.072005,
      0,
      6,
      2,
      4.573527,
      8.309153,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.974967,
      0.775380,
      0.580439,
      0.148948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562578,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.697162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242763,
      5.125087,
      NULL,
      0.130626,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.971358,
      NULL,
      0.829085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.447655,
      1.854955,
      2.569751,
      1,
      2,
      NULL,
      NULL,
      0,
      3,
      1.901655,
      NULL,
      0,
      1,
      0,
      0,
      1.657646,
      NULL,
      1.819851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527620,
      0,
      0,
      NULL,
      0.399406,
      0,
      1.155769,
      0,
      NULL,
      '31001',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      2,
      1,
      0.498073,
      NULL,
      1.061315,
      3.771831,
      NULL,
      2.670602);
commit;
end;
/


