set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '241',
      '24114433',
      43,
      25,
      '0012412',
      11.080236,
      NULL,
      3.956734,
      3,
      '140211',
      2,
      ' 0- 6-1996',
      30.405930,
      12,
      0.623353,
      NULL,
      0,
      1.265271,
      NULL,
      1.076131,
      1,
      1,
      1,
      0.786674,
      1,
      0,
      0,
      1,
      0.244757,
      NULL,
      1.148760,
      1,
      5,
      0,
      NULL,
      NULL,
      0.109667,
      1,
      1.114456,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.514060,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.804863,
      2,
      1.866670,
      1,
      NULL,
      0.485912,
      0.510258,
      2,
      2,
      1.360566,
      0,
      1.404155,
      1.487007,
      0,
      1,
      1.869057,
      1.922036,
      NULL,
      NULL,
      0.803655,
      NULL,
      NULL,
      0.092249,
      1,
      0,
      0,
      0,
      0.878510,
      0.877003,
      NULL,
      NULL,
      1,
      0.822127,
      NULL,
      1.690539,
      3.909214,
      NULL,
      1,
      1.494596,
      0.032186,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.071459,
      0,
      3,
      0.677456,
      NULL,
      NULL,
      NULL,
      NULL,
      3.043809,
      2,
      4.827371,
      0.240891,
      NULL,
      6.950672,
      7,
      4.374173,
      6,
      1,
      3,
      NULL,
      8,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.687103,
      0.068148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.649560,
      1,
      0,
      1,
      0,
      0.842596,
      0.929863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969016,
      NULL,
      NULL,
      NULL,
      NULL,
      0.795017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.913089,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.248552,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.824533,
      NULL,
      3,
      1,
      3,
      0,
      1.236302,
      0,
      3,
      0,
      1.765838,
      NULL,
      0,
      1.006717,
      0,
      1,
      NULL,
      1.711402,
      1.736507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182857,
      1.551445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376870,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.441367,
      0,
      1.778278,
      NULL,
      1,
      0.225685,
      0,
      0,
      3,
      '21130',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.036252,
      '',
      '',
      '',
      0,
      1.199490,
      1,
      0,
      2.471954,
      0,
      NULL,
      NULL,
      2);
commit;
end;
/


