set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '43203040',
      7.065468,
      54.432379,
      '0444202',
      162.077356,
      NULL,
      0.228819,
      0,
      NULL,
      0,
      '10-29-1977',
      18.037293,
      40.962070,
      NULL,
      NULL,
      NULL,
      0.669099,
      3,
      0,
      0.738517,
      1.241796,
      0,
      3,
      NULL,
      1,
      0,
      1.189472,
      0.305905,
      0,
      0.438789,
      0,
      5,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0.533666,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5.097267,
      1.583950,
      3,
      0.945858,
      1.599867,
      0,
      1.665872,
      2,
      0,
      0.685176,
      NULL,
      1,
      0,
      0.499730,
      NULL,
      3,
      NULL,
      2.102289,
      NULL,
      1.536567,
      NULL,
      5,
      0,
      1,
      1.134690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978672,
      NULL,
      1.721722,
      NULL,
      NULL,
      NULL,
      0.019662,
      0,
      2,
      0,
      1,
      1.918814,
      NULL,
      0,
      1.099850,
      0.561620,
      0.232116,
      1.667144,
      NULL,
      0,
      4,
      0,
      NULL,
      3.402707,
      1,
      0.056587,
      2.303064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1,
      2.098346,
      4,
      NULL,
      9.952574,
      5,
      NULL,
      NULL,
      9.090562,
      NULL,
      1.595298,
      0.183596,
      1.754976,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.628027,
      0,
      0,
      1,
      0,
      0.921723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.491730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.857290,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.898133,
      NULL,
      2.293145,
      NULL,
      0.042129,
      0,
      0.302736,
      NULL,
      NULL,
      NULL,
      1,
      1.798720,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192341,
      3.497577,
      1.295124,
      1.434210,
      1,
      0.771377,
      3,
      1.376120,
      1,
      1,
      0.523707,
      1,
      1.455997,
      0,
      0,
      NULL,
      0.459976,
      1.291719,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.565227,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580655,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467693,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.123769,
      NULL,
      1.169099,
      1.365794,
      NULL,
      1,
      1.675998,
      '30244',
      '',
      NULL,
      0.145913,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      0.001204,
      3.605598,
      0,
      3.925012,
      NULL,
      NULL,
      2,
      1.719659);
commit;
end;
/


