set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '412',
      NULL,
      NULL,
      15.369838,
      NULL,
      33.280419,
      4,
      2.274703,
      NULL,
      '332100',
      6,
      ' 0- 3-1986',
      53.756499,
      23.313022,
      1.853421,
      NULL,
      NULL,
      1.971161,
      0,
      1.414201,
      0.173454,
      0,
      1.573341,
      1.971371,
      1.653619,
      NULL,
      1.008791,
      0,
      1,
      2,
      0,
      1.941769,
      2.339579,
      0.386561,
      1,
      NULL,
      NULL,
      NULL,
      2.673018,
      NULL,
      0.741181,
      0.949323,
      0.051723,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.921266,
      3,
      NULL,
      2.622986,
      1,
      0.401667,
      3.582777,
      1,
      2.971229,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      0,
      1,
      NULL,
      1.113230,
      1.719109,
      0.872737,
      5,
      1,
      0,
      1.018900,
      1.347347,
      NULL,
      NULL,
      0.632953,
      NULL,
      NULL,
      0.531147,
      NULL,
      NULL,
      1,
      0,
      2.768124,
      2.334740,
      NULL,
      1.803333,
      NULL,
      1,
      0.223889,
      1.775783,
      0.087822,
      NULL,
      1,
      NULL,
      NULL,
      1.377329,
      NULL,
      1.053868,
      0,
      2.018332,
      0.246741,
      3.760334,
      1.723422,
      0,
      1.823753,
      1,
      1.731004,
      1,
      2.480892,
      0,
      0,
      4,
      0,
      3,
      NULL,
      3,
      4,
      0.754926,
      8,
      5,
      3,
      5.869476,
      1.664478,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.628285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477583,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.933812,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.742853,
      1.830457,
      1,
      0.954312,
      NULL,
      NULL,
      NULL,
      NULL,
      3.497024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.090672,
      0,
      1,
      2,
      0.804777,
      0.556719,
      1,
      3.545027,
      0.423131,
      NULL,
      1,
      0,
      1.668987,
      0.144672,
      0,
      1.470363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.438258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.192629,
      NULL,
      NULL,
      0,
      2,
      '03044',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.930635,
      '',
      NULL,
      '',
      3.758227,
      4,
      NULL,
      3.844964,
      2.353902,
      2.209560,
      2.899629,
      0,
      0.317395);
commit;
end;
/


