set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '31202104',
      60,
      36,
      '2142240',
      119,
      0,
      1,
      1,
      '334213',
      2,
      NULL,
      NULL,
      9,
      1,
      NULL,
      0.092084,
      0.323675,
      3.179512,
      1.637091,
      0.576420,
      1,
      0,
      NULL,
      1.141301,
      0.517146,
      NULL,
      0,
      1.544898,
      NULL,
      NULL,
      0.286808,
      3,
      0,
      1.041098,
      1,
      1.458211,
      0,
      NULL,
      0,
      0.176343,
      1,
      1,
      0.949154,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.609490,
      1.035435,
      3.696874,
      0,
      1,
      0,
      3.238404,
      0.511171,
      NULL,
      NULL,
      NULL,
      3.523030,
      1.551260,
      0,
      1.815180,
      NULL,
      NULL,
      1,
      1.540173,
      NULL,
      0,
      NULL,
      1.122033,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.458101,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.368962,
      NULL,
      3.254597,
      NULL,
      1.732331,
      NULL,
      1,
      1.750031,
      0.199085,
      3.669512,
      1,
      1,
      1,
      NULL,
      1.086241,
      NULL,
      NULL,
      NULL,
      1,
      0.899535,
      4,
      NULL,
      3,
      1.599997,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191256,
      2.811372,
      3,
      3,
      4.023308,
      NULL,
      3,
      8.931539,
      5.240725,
      7.240588,
      8,
      2,
      NULL,
      0.588130,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146354,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0.918225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.914072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.061361,
      0.809990,
      0,
      0,
      1.099800,
      NULL,
      NULL,
      NULL,
      0.702412,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.077111,
      3.085837,
      NULL,
      NULL,
      NULL,
      1,
      0.270204,
      2,
      1,
      NULL,
      NULL,
      0.630988,
      0,
      1,
      0.486893,
      0,
      1,
      1.887280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008397,
      1.346739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.613395,
      0,
      3.824960,
      '00243',
      '',
      NULL,
      1.940017,
      '',
      '',
      '',
      1.344749,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      3,
      2.075135,
      1,
      0.684969,
      3,
      5.408543);
commit;
end;
/


