set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14410323',
      49.328267,
      40.998270,
      '1114042',
      NULL,
      5,
      3.538823,
      3,
      '143424',
      0,
      ' 7-22-1984',
      NULL,
      5,
      0,
      NULL,
      1.471109,
      0,
      NULL,
      0,
      0,
      1.397909,
      1.224356,
      NULL,
      1.595322,
      1,
      3,
      1,
      0.387456,
      1,
      NULL,
      1.281447,
      2.310733,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.603398,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.164395,
      0.029308,
      3,
      NULL,
      2,
      1.946991,
      NULL,
      1.649193,
      NULL,
      0.131127,
      NULL,
      0,
      3,
      0,
      1.988106,
      1.427828,
      1.822637,
      4,
      0,
      NULL,
      0.047012,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.998721,
      1,
      1.540705,
      1,
      1.961424,
      NULL,
      2.560033,
      1.540110,
      1,
      0.992608,
      1,
      1.671543,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      1,
      2,
      1,
      1.940479,
      1.387506,
      0.019045,
      3,
      0.461318,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5.023004,
      1,
      NULL,
      5,
      4,
      4,
      NULL,
      3.650581,
      8.348665,
      1,
      NULL,
      9,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.666473,
      1.749017,
      0.223187,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185854,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.069044,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.172001,
      NULL,
      5,
      1,
      0.558804,
      NULL,
      0.307497,
      NULL,
      NULL,
      NULL,
      NULL,
      2.025997,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.134320,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      0.638640,
      1.908210,
      NULL,
      0,
      1,
      1.018708,
      0.617487,
      1.173586,
      1,
      1.912785,
      1.291999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.253192,
      0.329040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539185,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119046,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.354992,
      NULL,
      0,
      NULL,
      1,
      1,
      1.272980,
      '23021',
      '',
      '',
      1.029933,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      1.650545,
      3,
      1.581805,
      2,
      3.084559,
      1,
      2,
      0);
commit;
end;
/


