set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13033201',
      79.122814,
      32,
      '4112241',
      96.406926,
      5,
      1.671850,
      2,
      '431240',
      NULL,
      ' 0- 1-1984',
      NULL,
      50.061330,
      1,
      NULL,
      1,
      0.065137,
      1.238327,
      0.852088,
      NULL,
      0,
      0.343199,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.476642,
      3,
      1,
      1.399024,
      5.690722,
      NULL,
      0,
      1.600266,
      0.020932,
      0,
      1.312344,
      0,
      0,
      NULL,
      0,
      1.787846,
      NULL,
      NULL,
      1.665514,
      NULL,
      NULL,
      0,
      1.954553,
      1,
      0.805277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455143,
      NULL,
      0.387398,
      1.135244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.267170,
      1,
      1,
      NULL,
      0,
      0.048164,
      0.342511,
      1,
      NULL,
      1,
      1.578750,
      0,
      0.553321,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838389,
      1,
      1.315932,
      0,
      0,
      2,
      0.096599,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123874,
      NULL,
      3.277333,
      3.680217,
      1.378354,
      0.398847,
      0.542800,
      NULL,
      3.651166,
      1.863222,
      5,
      NULL,
      6,
      0.615678,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.440291,
      0.729003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.866660,
      0.267319,
      NULL,
      1.255111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549220,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.871861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330583,
      NULL,
      0,
      1.753550,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.956711,
      2,
      0.900941,
      1,
      0.659495,
      1.254930,
      3.174735,
      NULL,
      0,
      2,
      0,
      0.806490,
      1.424580,
      NULL,
      NULL,
      0,
      1.997538,
      1,
      1.299754,
      1.220635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685082,
      NULL,
      NULL,
      NULL,
      NULL,
      2.583032,
      1.750446,
      NULL,
      NULL,
      1.852376,
      1,
      1.639869,
      2,
      NULL,
      '30121',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      2,
      2.107282,
      NULL,
      NULL,
      3,
      NULL,
      3.941094,
      3);
commit;
end;
/


