set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1300',
      '21423320',
      NULL,
      43.052029,
      '0302212',
      110.689809,
      NULL,
      3,
      3,
      '332140',
      NULL,
      ' 7-15-2002',
      3,
      NULL,
      NULL,
      NULL,
      0,
      1.206715,
      2.405404,
      0.896347,
      0.703611,
      1,
      0.431517,
      3,
      NULL,
      1,
      0.559637,
      0.081390,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.293407,
      NULL,
      0.056387,
      NULL,
      0,
      2,
      1,
      NULL,
      0,
      1.317353,
      1.528150,
      NULL,
      NULL,
      1.528175,
      NULL,
      NULL,
      NULL,
      0.280352,
      1.841941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.571798,
      1.568844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.218104,
      NULL,
      0.707827,
      0,
      5,
      2.444606,
      NULL,
      1.935813,
      NULL,
      1.168704,
      0,
      NULL,
      0,
      1,
      NULL,
      0.850529,
      0,
      1.897319,
      NULL,
      1,
      0,
      1,
      NULL,
      4,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3.164354,
      2.599844,
      4.345211,
      9,
      NULL,
      NULL,
      NULL,
      1.867974,
      3,
      1,
      NULL,
      1.679497,
      0.705032,
      1,
      NULL,
      NULL,
      1,
      1.432367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937441,
      0,
      1,
      0,
      1,
      NULL,
      1.647823,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.081815,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.999039,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083780,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.556659,
      3,
      2,
      3.431902,
      2.129157,
      0,
      0.669149,
      2,
      1,
      1.303152,
      0.993569,
      1.644056,
      1,
      0.846058,
      0.995103,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300392,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636156,
      NULL,
      NULL,
      NULL,
      NULL,
      0.366726,
      0,
      0.318390,
      NULL,
      1,
      1.690678,
      1,
      NULL,
      3,
      '40112',
      '',
      '',
      1.243344,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      1,
      1,
      3,
      0.177233,
      2.046915,
      0,
      0,
      1);
commit;
end;
/


