set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921809';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4211',
      '40401114',
      9,
      62,
      '1112200',
      188.952108,
      2,
      1,
      2,
      '224300',
      0,
      '10-29-1987',
      31,
      1.028965,
      1,
      NULL,
      0,
      1.655933,
      0,
      1.521605,
      1,
      NULL,
      0.821287,
      0.619226,
      0.790773,
      NULL,
      3,
      0.401572,
      1,
      1.891792,
      1,
      1.431850,
      NULL,
      1.223171,
      1,
      0,
      0.026610,
      1.898825,
      5,
      NULL,
      0,
      0.141598,
      1.647011,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.682274,
      1.574416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504530,
      1,
      1.149780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.586445,
      0,
      0,
      0,
      1.894447,
      1.724972,
      0,
      1.363682,
      1,
      0.654939,
      1.350281,
      5.993532,
      1.540579,
      0,
      0.485507,
      0.874756,
      0.168294,
      NULL,
      NULL,
      4,
      0.505916,
      0,
      0,
      1,
      2.725880,
      NULL,
      1.519071,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.489048,
      1,
      6.930915,
      2.655579,
      8,
      7.974045,
      1,
      0.213756,
      1,
      NULL,
      1.622845,
      NULL,
      NULL,
      2.947554,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576845,
      0,
      1,
      1,
      NULL,
      0.852600,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006017,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.504981,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.348792,
      5.486157,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.117833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.294272,
      1.637207,
      2,
      3,
      0.982227,
      1.820444,
      2.137969,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.808893,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0.681211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.057891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596113,
      NULL,
      NULL,
      1.894042,
      0,
      1.301699,
      1,
      2,
      '13103',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.136668,
      '',
      '',
      '',
      NULL,
      NULL,
      3.822917,
      1,
      2.066149,
      3,
      NULL,
      0.855479,
      3.970726);
commit;
end;
/


