set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '030',
      '44312104',
      26,
      56,
      '1120403',
      15.319086,
      6,
      3.936605,
      3,
      '442111',
      3.794186,
      '11-14-1974',
      29,
      2,
      0,
      NULL,
      2.841781,
      3.830924,
      NULL,
      0,
      3,
      1.429772,
      2,
      1.430728,
      1,
      NULL,
      3.372218,
      0,
      1,
      0,
      NULL,
      0,
      0.857632,
      1.621303,
      2,
      2.944236,
      0,
      0.578051,
      2.922207,
      NULL,
      2.232070,
      1,
      NULL,
      0.827045,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.699098,
      4,
      0.621575,
      3,
      NULL,
      1,
      1.523841,
      3,
      1,
      1.832080,
      NULL,
      1.121508,
      2.100697,
      0.096765,
      0,
      2,
      2.051092,
      2,
      2.016662,
      1.486076,
      NULL,
      1,
      3.952654,
      1,
      2,
      NULL,
      0.413415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.981845,
      1,
      0.719533,
      1.236332,
      NULL,
      0,
      1.467868,
      0,
      0,
      1,
      0,
      0.961854,
      0.760567,
      NULL,
      1,
      1,
      1,
      NULL,
      1.758692,
      0,
      1,
      0.403565,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      4,
      0,
      1.252487,
      NULL,
      2.608193,
      1,
      0.544390,
      NULL,
      3.879544,
      6.053751,
      0.533189,
      4.718495,
      1,
      5,
      1,
      NULL,
      0,
      NULL,
      1.396936,
      0,
      NULL,
      1,
      0.862421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690790,
      1.222218,
      1,
      0,
      0,
      1.507310,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.559939,
      3.162644,
      1,
      NULL,
      NULL,
      NULL,
      1.057856,
      1.679132,
      0.790007,
      1.318075,
      0.473461,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.092322,
      2.213995,
      2,
      3.373957,
      0.666277,
      1,
      1,
      0.941376,
      2,
      1,
      1.731289,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      0.108835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '10243',
      NULL,
      '',
      1.997491,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      1,
      1,
      NULL,
      0.522038,
      1,
      NULL,
      NULL,
      NULL,
      0.216457);
commit;
end;
/


