set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0400',
      '02203404',
      77,
      51,
      '0133214',
      NULL,
      1,
      3.419265,
      NULL,
      NULL,
      1,
      '10-15-1987',
      20,
      38.889709,
      1.881671,
      NULL,
      1.398299,
      2,
      NULL,
      0.419845,
      NULL,
      0.313399,
      3.580898,
      1.033445,
      1.756710,
      NULL,
      NULL,
      1.376217,
      NULL,
      NULL,
      1.649859,
      1.877431,
      NULL,
      NULL,
      NULL,
      6.153170,
      8,
      4.474341,
      5.825945,
      NULL,
      1.408111,
      NULL,
      3,
      1.930183,
      NULL,
      NULL,
      1.070573,
      NULL,
      NULL,
      6.793825,
      NULL,
      4.647538,
      0.030844,
      1,
      1.701289,
      2,
      2,
      2.901038,
      0.194951,
      1,
      3,
      2.756864,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.842946,
      0.395741,
      NULL,
      1,
      7.237293,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.831361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183965,
      1,
      NULL,
      1.319930,
      1.712979,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.003270,
      0,
      0,
      1,
      1.045584,
      1.683130,
      NULL,
      1,
      1.828483,
      0,
      1,
      0,
      0.631146,
      NULL,
      NULL,
      NULL,
      0.322605,
      1.292218,
      0.994952,
      5,
      0,
      NULL,
      1,
      NULL,
      6.196621,
      NULL,
      7.972575,
      NULL,
      NULL,
      5,
      0.844768,
      NULL,
      7,
      7,
      4.455378,
      0,
      NULL,
      1.347138,
      8.370653,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.388213,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.541906,
      1.589909,
      1.442008,
      1.514907,
      2.437112,
      3.187648,
      0.515911,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.726086,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.937229,
      1.058845,
      NULL,
      3,
      1.395591,
      1,
      1.538491,
      NULL,
      3.268509,
      1,
      1.720938,
      0.714877,
      1.766565,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.152153,
      '',
      '',
      '',
      0,
      0,
      3,
      2,
      NULL,
      0.152270,
      0,
      3.089306,
      1.766977);
commit;
end;
/


