set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00413132',
      NULL,
      13,
      '0302021',
      52.371784,
      2,
      1.183534,
      1,
      '240432',
      6.066585,
      ' 2- 2-1999',
      7,
      8,
      NULL,
      NULL,
      NULL,
      2.149389,
      1,
      0,
      2,
      NULL,
      0.960402,
      1.972383,
      0,
      NULL,
      7.227685,
      1,
      0,
      1.308627,
      1,
      0,
      7.344960,
      1,
      1,
      1.850632,
      6.517618,
      8,
      9,
      1,
      5.959651,
      3.902052,
      0,
      1,
      NULL,
      NULL,
      0.390582,
      NULL,
      NULL,
      NULL,
      9,
      1,
      0,
      3,
      1.341155,
      3.143623,
      1.917816,
      2,
      0,
      2.887757,
      0,
      0,
      NULL,
      2.118065,
      1,
      3.530876,
      1.247385,
      0.581535,
      0,
      1.006341,
      10.601689,
      6.262327,
      1,
      0,
      2,
      1.732934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.009971,
      NULL,
      0,
      0.564169,
      1,
      0,
      0,
      1.346765,
      1,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.037847,
      1.795796,
      1.970086,
      0,
      NULL,
      0.765303,
      1,
      NULL,
      1.947842,
      0,
      0.709695,
      1,
      0.489250,
      1,
      0,
      5.508343,
      0,
      1,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      4,
      2.119668,
      NULL,
      NULL,
      3.220227,
      2,
      NULL,
      0.188580,
      1,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.799210,
      1,
      2.293100,
      0.915900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974366,
      NULL,
      7.722391,
      0,
      0,
      7,
      1,
      0.691412,
      2,
      0.532140,
      2.300126,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      6.139470,
      NULL,
      0,
      1.503445,
      NULL,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507396,
      3,
      3,
      0,
      3.673182,
      1,
      0,
      0.261487,
      0,
      1.566027,
      0.899962,
      1.424103,
      0,
      0,
      1.382001,
      1.132723,
      0.584183,
      1,
      NULL,
      1.526747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44432',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      3,
      3.203755,
      2.715025,
      0.608786,
      NULL,
      1.539796,
      3,
      NULL);
commit;
end;
/


