set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '24140101',
      8.211396,
      62.437777,
      '4324304',
      63.246940,
      1,
      2,
      NULL,
      '342300',
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.625842,
      0,
      NULL,
      NULL,
      2,
      1,
      2,
      0,
      1.686251,
      NULL,
      NULL,
      1.583523,
      0,
      4.844071,
      0.242447,
      0.492668,
      9.307603,
      1.928447,
      4.674074,
      4,
      NULL,
      5,
      1.349787,
      1,
      5,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.807501,
      NULL,
      NULL,
      0,
      7,
      0.660741,
      2,
      0,
      1.084062,
      1.294448,
      2.768296,
      1,
      NULL,
      0,
      3.104711,
      3.813492,
      2.148853,
      NULL,
      0,
      NULL,
      0.403539,
      0,
      1,
      1.862437,
      NULL,
      NULL,
      1,
      1,
      1.168794,
      0,
      NULL,
      NULL,
      1.213811,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.147086,
      3,
      0,
      NULL,
      0,
      0.866767,
      1,
      0,
      0.199334,
      1,
      0.649775,
      0,
      1,
      0.234424,
      NULL,
      0.840575,
      NULL,
      1.049990,
      0,
      NULL,
      0.278962,
      0.161153,
      0.413276,
      0.844040,
      1.084440,
      0.358365,
      1,
      2,
      0.382406,
      4,
      1.226062,
      4.637209,
      NULL,
      0,
      7.995119,
      NULL,
      NULL,
      5.245461,
      NULL,
      2.113470,
      NULL,
      4.988130,
      7,
      NULL,
      5.204792,
      1.821900,
      0.303966,
      1.770112,
      0.807527,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610606,
      3.333693,
      1,
      NULL,
      NULL,
      NULL,
      3.880311,
      1.535428,
      1.104070,
      5.556013,
      0,
      NULL,
      0.253124,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.361053,
      3.167291,
      NULL,
      1,
      2,
      0.872804,
      1.562182,
      3,
      0,
      NULL,
      0.464259,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.051017,
      0.559694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.348794,
      '00013',
      '',
      NULL,
      0.360657,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.969739,
      2.636562,
      0,
      2.554264,
      1.187676,
      2.110357,
      3.410838,
      1.328316,
      2.947030);
commit;
end;
/


